#ifndef PIPE_H
#define PIPE_H

// enumerated type that represents the 6 possible pipe sizes
enum pipeType {PIPE16, PIPE32, PIPE48, PIPE64, PIPE80, PIPE96};

// class that represents a pair of pipes in the Flappy Bird game
class Pipe
{
public:
    // Constructor
    Pipe();
    // Get Functions
    int getWidth();             // returns the pipe's width
    int getX();                 // returns the pipe's current x position
    int getY();                 // returns the pipe's current y position
    int getOldX();              // returns the pipe's previous x position
    pipeType getType();         // returns the pipe's size
    // Member Functions
    void move(int gameSpeed);   // moves the pipe given the current game speed
    
private:
    // variables
    int x;                          // the pipe's current x position
    int y;                          // the height of the top pipe in the pair of pipes
    int oldX;                       // the pipe's previous x position
    pipeType type;                  // the pipe's size
    // constants
    static const int width = 32;    // the pipe's width
};

#endif // PIPE_H