#include "pipe.h"
#include <stdlib.h>

Pipe::Pipe(){
    x = 128;                                // the pipe starts at the right side of the screen
    int random = rand() % 6;                // generates a random number between 0 and 5
    y = (random + 1) * 16;                  // converts random number to pipe size
    type = static_cast<pipeType>(random);   // cast int to pipeType
}

int Pipe::getWidth() {
    return width;
}

int Pipe::getOldX() {
    return oldX;   
}

int Pipe::getY() {
    return y;   
}

int Pipe::getX() {
    return x;
}

pipeType Pipe::getType() {
    return type;
}

void Pipe::move(int gameSpeed) {
    oldX = x;       // store old x position
    x -= gameSpeed; // move the pipe left (distance ranges from 1 to 5)
}