#include "uLCD_4DGL.h"

class Paddle 
{
public:
    // Constructors
    Paddle(uint8_t, uint8_t, uint8_t, uint8_t);
    // Set Functions
    void setLimits(uint8_t, uint8_t); // left and right limits of the paddle
    void setMaxMove(uint8_t);
    // Paddle location functions
    uint8_t getX();
    void setX(uint8_t);
    // Member Functions
    void move(float); // false means move left, true means move right
    bool checkHit(uint8_t, uint8_t, uint8_t); // Using a position and size, checks to see if something has hit the paddle
    uint8_t returnAngle(uint8_t, uint8_t); // Using a ball x position, gives a return vx and vxDir
    bool returnDir(uint8_t, uint8_t);
    void reset(uint8_t, uint8_t);

private:
    // Data members are suggestions, feel free to add/remove
    uint8_t x;
    uint8_t y;
    uint8_t length;
    uint8_t width;
    uint8_t maxMove;
    uint8_t leftLim;
    uint8_t rightLim;
    bool bottom; //0 is top, 1 is bottom
};

