#include "huzzah.h"
#include "mbed.h"
#include "rtos.h"

Huzzah::Huzzah(char *enterssid, char *enterpassword, Serial *esp) {
    ssid = enterssid;     // enter WiFi router ssid inside the quotes
    pwd = enterpassword;
    this->esp = esp;
    //ESP=esp; // enter WiFi router password inside the quotes     
    }
//set ESP baudrate if necessary
void Huzzah::setbaudrate()
{
    strcpy(snd, "AT+CIOBAUD=115200\r\n");   // change the numeric value to the required baudrate
    SendCMD();
}
//Configurate ESP to Station mode and set username and password
void Huzzah::config()
    {
    strcpy(snd,".\r\n.\r\n");
    SendCMD();
    Thread::wait(1000);
    
    strcpy(snd,"node.restart()\r\n");
    SendCMD();
    Thread::wait(3000);
    
    strcpy(snd, "wifi.setmode(wifi.STATION)\r\n");
    SendCMD();
    Thread::wait(2000);
    
    strcpy(snd, "wifi.sta.config(\"");
    strcat(snd, ssid);
    strcat(snd, "\",\"");
    strcat(snd, pwd);
    strcat(snd, "\")\r\n");
    SendCMD();
    Thread::wait(2000);
    }

void Huzzah::SendCMD()
{
    esp->printf("%s", snd);
}

void Huzzah::sendwebpage(int _highscore1, int _highscore2)
{
        this->_highscore1=_highscore1;
        this->_highscore2=_highscore2;
        
        strcpy(snd, "srv=net.createServer(net.TCP)\r\n");
        SendCMD();
        Thread::wait(500);
        strcpy(snd, "srv:listen(80,function(conn)\r\n");
        SendCMD();
        Thread::wait(500);
        strcpy(snd, "conn:on(\"receive\",function(conn,payload)\r\n");
        SendCMD();
        Thread::wait(500);
        strcpy(snd, "print(payload)\r\n");
        SendCMD();
        Thread::wait(500);
        
        strcpy(snd, "conn:send(\"<!DOCTYPE html>\")\r\n");
        SendCMD();
        Thread::wait(500);
        
        strcpy(snd, "conn:send(\"<html>\")\r\n");
        SendCMD();
        Thread::wait(500);
        
        strcpy(snd, "conn:send(\"<h1> PVP Wireless Pong High Scores</h1>\")\r\n");
        SendCMD();
        Thread::wait(500);
        
        sprintf(snd, "conn:send(\"<h2> Player 1 high score: %i, Player 2 High Score: %i </h2>\")\r\n",_highscore1, _highscore2);
        SendCMD();
        Thread::wait(500);
        
        strcpy(snd, "conn:send(\"<h2> Great Job!</h2>\")\r\n");
        SendCMD();
        Thread::wait(500);
        
        strcpy(snd, "conn:send(\"</html>\")\r\n");
        SendCMD();
        Thread::wait(500);
        
        strcpy(snd, "end)\r\n");
        SendCMD();
        Thread::wait(500);
        
        strcpy(snd, "conn:on(\"sent\",function(conn) conn:close() end)\r\n");
        SendCMD();
        Thread::wait(500);
        
        strcpy(snd, "end)\r\n");
        SendCMD();
        Thread::wait(500);

}
