#include "paddle.h"

Paddle::Paddle(uint8_t initx, uint8_t inity, uint8_t olength, uint8_t owidth){
    x = initx;
    y = inity;
    length = olength;
    width = owidth;
    if (y < 100) {
        bottom = false;
    }
    else {
        bottom = true;
    }
}

void Paddle::setLimits(uint8_t left, uint8_t right){
    leftLim = left;
    rightLim = right;
}

void Paddle::setMaxMove(uint8_t amt){
    maxMove = amt;
}

uint8_t Paddle::getX(){
    return x;
}

void Paddle::setX(uint8_t newx){
    x = newx;
}

void Paddle::move(float amt){
    if (x + amt*maxMove + length > rightLim)
        x = rightLim - length;
    else if (x + amt*maxMove < leftLim)
        x = leftLim;
    else
        x = x + amt*maxMove;
}

bool Paddle::checkHit(uint8_t ballX, uint8_t ballY, uint8_t size){
    if (ballX+size/2 >= x && ballX+size/2 <= x+length){
        if (bottom && (ballY+size >= y-width && ballY <= y-width)){
            return true;
        }
        else if (!bottom && (ballY+size >= y+width && ballY <= y+width)){
            return true;
        }
    }
    return false;
}

uint8_t Paddle::returnAngle(uint8_t ballX, uint8_t size){
    uint8_t dist = abs((ballX + size/2) - (x + length/2));
    if (dist < 5)
        return 0;
    else if (dist < 10)
        return 1;
    else if (dist < 15)
        return 2;
    else
        return 3;
}

bool Paddle::returnDir(uint8_t ballX, uint8_t size){
    if ((ballX+size/2) > (x+length/2)){
        return true;
    }
    else {
        return false;
    }
}

void Paddle::reset(uint8_t initx, uint8_t inity){
    x = initx;
    y = inity;
}