#include "ball.h"

Ball::Ball(uint8_t initx, uint8_t inity, uint8_t size){
    x = initx;
    y = inity;
    diameter = size;
}

void Ball::setVx(uint8_t newvx){
    vx = newvx;
}

void Ball::setVxDir(bool dir){
    vxDir = dir;
}

void Ball::setVy(uint8_t newVy){
    vy = newVy;
}

void Ball::setVyDir(bool dir){
    vyDir = dir;
}

uint8_t Ball::getSize(){
    return diameter;
}

uint8_t Ball::getX(){
    return (uint8_t)x;
}

uint8_t Ball::getY(){
    return (uint8_t)y;
}

uint8_t Ball::getFutureX(){
    if (vxDir)
        return x+vx;
    else
        return x-vx;
}

uint8_t Ball::getFutureY(){
    if (vyDir)
        return y+vy;
    else
        return y-vy;
}

void Ball::reverseXDirection(){
    vxDir = !vxDir;
}

void Ball::reverseYDirection(){
    vyDir = !vyDir;
}

void Ball::reset(uint8_t newx, uint8_t newy, int newvx, int newvy){
    x = newx;
    y = newy;
    vx = newvx;
    vy = newvy;
}

void Ball::update(){ 
    if (vxDir)
        x = x+vx;
    else
        x = x-vx;
    
    if (vyDir)
        y = y+vy;
    else
        y = y-vy;
}