#include "mbed.h"




Serial pc(USBTX, USBRX); //Initalise PC serial comms
Serial xbee(PTE0,PTE1);  //

int term = 0;
int present = 0;
int acc_x[2];
int acc_y[2];
int acc_z[2];
int i = 0;
int j = 0;
char data[21];
float angleX, angleY, angleZ, total, angleX_old;
int v = 0;

DigitalOut myled(LED1);//  creation d'une led
SPI capteur(PTD2, PTD3, PTD1); // mosi, miso, sclk
SPI capteur_2(PTD6, PTD7, PTD5); // mosi, miso, sclk  
Ticker action; //  creation d'un timer




//Phalanges doigt 0
DigitalOut D0C1(PTA16);// Pouce bout
DigitalOut D0C2(PTA17);// Pouce milieu
DigitalOut D0C3(PTE31);// Pouce base

//Phalanges doigt 1
DigitalOut D1C1(PTC13);// Index bout
DigitalOut D1C2(PTC16);// Index milieu
DigitalOut D1C3(PTC17);// Index base

//Phalanges doigt 2
DigitalOut D2C1(PTC10);// Majeur bout
DigitalOut D2C2(PTC11);// Majeur milieu
DigitalOut D2C3(PTC12);// Majeur base

//Phalanges doigt 3
DigitalOut D3C1(PTC4);// Annulaire bout
DigitalOut D3C2(PTC5);// Annulaire milieu
DigitalOut D3C3(PTC6);// Annulaire base

//Phalanges doigt 4
DigitalOut D4C1(PTC7);// Auriculaire bout
DigitalOut D4C2(PTC0);// Auriculaire milieu
DigitalOut D4C3(PTC3);// Auriculaire base

struct S_accel{
    int x;
    int y;
    int z;
    DigitalOut *CS;
}a[15], b[15];
// On crée ici deux tableaux de structures qui sont voués à stocker les données de chaque accéléromètre sur les axes x, y et z


void Init_Cs(void){ // Fonction d'initialisation des chip select
    //Phalanges doigt 0
    a[0].CS = &D0C1;
    a[1].CS = &D0C2;
    a[2].CS = &D0C3;

    //Phalanges doigt 1
    a[3].CS = &D1C1;
    a[4].CS = &D1C2;
    a[5].CS = &D1C3;

    //Phalanges doigt 2
    a[6].CS = &D2C1;
    a[7].CS = &D2C2;
    a[8].CS = &D2C3;

    //Phalanges doigt 3
    a[9].CS = &D3C1;
    a[10].CS = &D3C2;
    a[11].CS = &D3C3;

    //Phalanges doigt 4
    a[12].CS = &D4C1;
    a[13].CS = &D4C2;
    a[14].CS = &D4C3;
    
    for (i=0;i <= 14;i++){// Tous les Chip Select a 1
        *(a[i].CS) = 1;
    }
 }
//
void Write_Register(int cap, int addr, int valeur){ // Mise en marche des accéléromètres en écrivant dans le registre
    //Ecriture dans un registre
    if(cap <=5){
        *(a[cap].CS) = 0;
        valeur = (1<<8)+ valeur;
        capteur_2.write(addr);
        capteur_2.write(valeur);
        *(a[cap].CS) = 1;
    }else{
        //Ecriture dans un registre
        *(a[cap].CS) = 0;
        valeur = (1<<8)+ valeur;
        capteur.write(addr);
        capteur.write(valeur);
        *(a[cap].CS) = 1;
    }
}
//
int Read_Register(int cap, int addr){
    int addr_2;
    // Lecture d'un registre et affichage sur port comm
    if(cap <=5){
        addr_2 = (8<<4) + addr;
        *(a[cap].CS) = 0;
        capteur_2.write(addr_2);
        term = capteur_2.write(0x00);
        printf("Registre = 0x%X\r\n", term);
        *(a[cap].CS) = 1;
        return term;
    }else{
        addr_2 = (8<<4) + addr;
        *(a[cap].CS) = 0;
        capteur.write(addr_2);
        term = capteur.write(0x00);
        printf("Registre = 0x%X\r\n", term);
        *(a[cap].CS) = 1;
        return term;
    }
}
//
void Read_x(int cap){ // Lecture des données de l'accéléromètre sur l'axe x
    if(cap <=5){    
        *(a[cap].CS) = 0; // On active le Chip Select de la voie
        capteur_2.write(0xA8);
        acc_x[0]= capteur_2.write(0x00);
        //printf("X_L = 0x%X\r\n", acc_x[0]);  //Affichacge LSB axe X
        *(a[cap].CS) = 1;

        *(a[cap].CS) = 0;
        capteur_2.write(0xA9);
        acc_x[1] = capteur_2.write(0x00);
        //printf("X_H = 0x%X\r\n", acc_x[1]);  // Affichage MSB axe X
        *(a[cap].CS) = 1;

        a[cap].x = ((acc_x[1] <<8) | acc_x[0]);  //  Mise en forme valeur
        //printf("X = 0x%d\r\n", a[cap].x);  //  Affichage valeur axe x
    }else{
        *(a[cap].CS) = 0;
        capteur.write(0xA8);
        acc_x[0]= capteur.write(0x00);
        //printf("X_L = 0x%X\r\n", acc_x[0]);  //Affichacge LSB axe X
        *(a[cap].CS) = 1;
    
        *(a[cap].CS) = 0;
        capteur.write(0xA9);
        acc_x[1] = capteur.write(0x00);
        //printf("X_H = 0x%X\r\n", acc_x[1]);  // Affichage MSB axe X
        *(a[cap].CS) = 1;
        
        a[cap].x = (acc_x[1] <<8)+ acc_x[0];  //  Mise en forme valeur
        //printf("X = %d\r\n", a[cap].x);  //  Affichage valeur axe x
    }
}
//
void Read_y(int cap){ // Lecture des données de l'accéléromètres sur l'axe y
        if(cap <=5){    
            *(a[cap].CS) = 0;
            capteur_2.write(0xAA);
            acc_y[0]= capteur_2.write(0x00);
            //printf("Y_L = 0x%X\r\n", acc_y[0]);  //Affichacge LSB axe Y
            *(a[cap].CS) = 1;

            *(a[cap].CS) = 0;
            capteur_2.write(0xAB);
            acc_y[1] = capteur_2.write(0x00);
            //printf("Y_H = 0x%X\r\n", acc_y[1]);  // Affichage MSB axe Y
            *(a[cap].CS) = 1;

            a[cap].y = (acc_y[1] <<8)+ acc_y[cap];  //  Mise en forme valeur
            //printf("Y = 0x%X\r\n", a[0].y);  //  Affichage valeur axe Y
    }else{
        *(a[cap].CS) = 0;
        capteur.write(0xAA);
        acc_y[0]= capteur.write(0x00);
        //printf("Y_L = 0x%X\r\n", acc_y[0]);  //Affichacge LSB axe Y
        *(a[cap].CS) = 1;

        *(a[cap].CS) = 0;
        capteur.write(0xAB);
        acc_y[1] = capteur.write(0x00);
        //printf("Y_H = 0x%X\r\n", acc_y[1]);  // Affichage MSB axe Y
        *(a[cap].CS) = 1;

        a[cap].y = (acc_y[1] <<8)+ acc_y[cap];  //  Mise en forme valeur
        //printf("Y = 0x%X\r\n", a[0].y);  //  Affichage valeur axe Y
    }
}
//
void Read_z(int cap){ // Lecture des données de l'accéléromètre sur l'axe z
    if(cap <=5){    
        *(a[cap].CS) = 0;
        capteur_2.write(0xAC);
        acc_z[0]= capteur_2.write(0x00);
        //printf("Z_L = 0x%X\r\n", acc_z[0]);  //Affichacge LSB axe Z
        *(a[cap].CS) = 1;

        *(a[cap].CS) = 0;
        capteur_2.write(0xAD);
        acc_z[1] = capteur_2.write(0x00);
        //printf("Z_H = 0x%X\r\n", acc_z[1]);  // Affichage MSB axe Z
        *(a[cap].CS) = 1;

        a[cap].z = (acc_z[1] <<8)+ acc_z[0];  //  Mise en forme valeur
        //printf("Z = 0x%X\r\n", a[cap].z);  //  Affichage valeur axe Z
    }else{
        *(a[cap].CS) = 0;
        capteur.write(0xAC);
        acc_z[0]= capteur.write(0x00);
        //printf("Z_L = 0x%X\r\n", acc_z[0]);  //Affichacge LSB axe Z
        *(a[cap].CS) = 1;

        *(a[cap].CS) = 0;
        capteur.write(0xAD);
        acc_z[1] = capteur.write(0x00);
        //printf("Z_H = 0x%X\r\n", acc_z[1]);  // Affichage MSB axe Z
        *(a[cap].CS) = 1;

        a[cap].z = (acc_z[1] <<8)+ acc_z[0];  //  Mise en forme valeur
        //printf("Z = 0x%X\r\n", a[cap].z);  //  Affichage valeur axe Z
    }
}
//
void Capteur_present(void){// verification presence capteurs
    i = 0;
    for (i=0;i <= 5;i++){ // Pour les 6 premiers capteurs
        present = Read_Register(i, 0x0F);
        if( present == 0b01001001){
            printf("capteur_1 %X = OK\r\n", i);
        } else{
            printf("capteur_1 %X = Error\r\n", i);
        }
    }
    for (i=6;i <= 14;i++){ // Pour les 8 derniers capteurs
        present = Read_Register(i, 0x0F);
        if( present == 0b01001001){
            printf("capteur_2 %X = OK\r\n", i);
        } else{
            printf("capteur_2 %X = Error\r\n", i);
        }
    }
}
//
void lecture(void){ // traitement des données précédemment récupérées
        for(i=0;i <= 14;i++){ // Pour tous les capteurs, de 0 à 15
            //  Lecture des axes
            Read_x(i); // On appelle la fonction pour lire l'axe x
            Read_y(i); // On appelle la fonction pour lire l'axe y
            Read_z(i); // On appelle la fonction pour lire l'axe z
            
            a[i].x = (a[i].x + 32768)/2; // mise en forme des données
            a[i].y = (a[i].y + 32768)/2;
            a[i].z = (a[i].z + 32768)/2;
            
            a[i].x = a[i].x /100;
            /*a[i].x = a[i].x *100;
            a[i].x = (int)a[i].x /100;*/
            
            
            if(a[i].x >= 240) // On borne les données pour éviter au maximum les débordements et les données fantaisistes
            {
                a[i].x = 240;
            }
            if(a[i].x <= 180)
            {
                a[i].x = 180;
            }
            
            a[i].x = 180 - (a[i].x);
            a[i].x = -(a[i].x * 2);
            
            //printf("%d\r\n", a[5].x); // On affiche la donnée pour pouvoir vérifier les valeurs qui sont transmises. Toutes les opérations précédentes conduisent à une valeur comprise entre 0 et 120
            
           /* hc06.printf("Doigt 1 %d\r\n", a[3].x);
            
            hc06.printf("Doigt 2 %d\r\n", a[6].x);*/
            
            //hc06.printf("Doigt 1 %d\r\n", a[0].x);
            
            //hc06.printf("Doigt 2 %d\r\n", a[3].x);
            
/*          angleX = (0,0167 * a[i].x) - 300;
            
            angleX = (angleX_old + angleX) /2;
            angleX_old = angleX;
*/

            
            // Ajout dans le tableau   
            data[i] = a[i].x;
            
            
            //hc06.printf("%c %3d %c %3d ",'D',data[3],'G',data[6]);
            //hc06.printf("%d\r\n", data[6]); // On envoie la donnée par bluetooth via le module hc06 pour transmettre les données sur l'application Android
            //wait_ms(25); // Délai d'attente indispensable pour la synchronisation des données
                    }
                    
         
         
         for(i=3;i<9;i++){                         
        xbee.printf("%c", data[i]);
                    
             }       
                    
                    }




int main() {
Serial pc(USBTX, USBRX); //Initalise PC serial comms
Serial xbee(PTE0,PTE1);





    pc.baud(9600);
    xbee.baud(9600);
    char test;
    
    
    
    
     //  Configuration bus spi
    capteur.format(8,3);// Selection parametre du bus SPI
    capteur.frequency(5000000);// Vitesse du bus SPI
    
    capteur_2.format(8,3);// Selection parametre du bus SPI
    capteur_2.frequency(5000000);// Vitesse du bus SPI
    
    Init_Cs();//  Assignation des chip select
    
    Capteur_present();//  Verification presence capteurs
    
    for (i=0;i <= 5;i++){//  Mise en marche capteurs
        Write_Register(i, 0x20, 0x67);// registre CTRL_REG1_A AODR = 10Hz
    }
    
    for (i=6;i <= 14;i++){//  Mise en marche capteurs
        Write_Register(i, 0x20, 0x67);// registre CTRL_REG1_A AODR = 10Hz
    }
    
    while(1){
        
        if(xbee.readable()==1)
        {
            
            test = xbee.getc();
            
            
   if(test=='D')
    {
        
       pc.printf("ok"); 
       
       pc.printf("okfff"); 
       
           
              lecture();
           /*xbee.printf("%c",i);
           pc.printf("%c",i);*/
          wait_ms(5);
           
           
           
           
           
       
       

    }
    else if(test=='F')
    {
      pc.printf("F \r\n");
      xbee.putc('R'); 
       
    } 
    
            
            
    }
        
}  
}
