#include "mbed.h"
#include "PCA9685.h"



Serial xbee(PA_9, PA_10);
DigitalOut myled(LED1);
Serial pc(USBTX,USBRX);
I2C i2c_PCA(PB_9, PB_8); // Utilisation et déclaration d'un port I2C pour communiquer avec la carte PWM Adafruit
PCA9685 PCA_SERVO(ADDR, i2c_PCA, 50); 


//Phalanges doigt 0 // Définitions de chaque servomoteur sur chaque doigt. Le doigt 0 correspond à l'index, et les servos se suivent de haut en bas. M0 est donc le servo de la base du doigt, et M3 le servomoteur le plus haut
#define D0M1 0x00 // On attribue à chaque servomoteur une adresse sur laquelle on enverra l'ordre d'angle
#define D0M2 0x01 // Ces adresses correspondent à des ports de la carte PWM Adafruit
#define D0M3 0x02
#define D0M0 0x03

//Phalanges doigt 1 // Définitions de chaque servomoteur du doigt majeur
#define D1M1 0x04
#define D1M2 0x05
#define D1M3 0x06
#define D1M0 0x07

//Phalanges doigt 2 // Définitions de chaque servcomoteur de l'annulaire
#define D2M1 0x08
#define D2M2 0x09
#define D2M3 0x0A
#define D2M0 0x0B

//Phalanges doigt 3 // Définitions de chaque servomoteur de l'auriculaire
#define D3M1 0x0C
#define D3M2 0x0D
#define D3M3 0x0E
#define D3M0 0x0F


int i = 0;


void angle(int moteur, int valeur);

char test;

int main() {

pc.baud(9600);
xbee.baud(9600);
    
      PCA_SERVO.init(); //Initialisation des servomoteurs
    
    for(i=0;i<=15;i++){ // On met tous les servomoteurs dans une position qui équivaut à la position de repos
        PCA_SERVO.set_pwm_output_on_0(i, 0);
    }
    
    
    
      xbee.printf("D \r\n");   
    while(1) {
         
    
        
    if(xbee.readable()==1){
        
        
   
   

   for(i=1;i<4;i++)
   {
      test = xbee.getc();
      
      angle(i,test);
      pc.printf("%c",test);
       // wait_ms(5);
    }
    
  
    
    

      for(i=4;i<7;i++)
   {
      test = xbee.getc();
      
      angle(i,test);
      pc.printf("%c",test);
      
    } 
    
   
    
  
       //xbee.putc('F');
        
    }
    
    //wait_ms(10);
  
       xbee.printf("D \r\n");   

    
        
        
        
        
    }
       
    
    
}










void angle(int moteur, int valeur){ // Fonction qui envoie les données au servomoteur correspondant
        
    valeur = valeur * 10;// Mise en forme correspondant
    valeur = valeur + 1100;//  Ajout de l'offset
    
    if(valeur >= 2400) // On borne les données reçues
    {
        valeur = 2400;
    }
    if(valeur <= 1100)
    {
        valeur = 1100;
    }
    
    PCA_SERVO.set_pwm_pw(moteur, valeur); // Puis on envoie au moteur
}



















