#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include "Smiley.h"


LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;
AnalogIn anal(A4);
TS_StateTypeDef TS_State;
//LocalFileSystem local("local");

///////////////////////////////////Déclaration des variables///////////////////////////////////////////
float tension = 0;
float amp = 0;
int active=0;


uint16_t x, y;
uint8_t text[30];
uint8_t status;
uint8_t idx;
uint8_t cleared = 0;
uint8_t prev_nb_touches = 0;
///////////////////////////////////Déclaration des variables///////////////////////////////////////////



//////////////////////////////////////////PROTOTYPE////////////////////////////////////////////////////
void Init_TS(void);             //Fonction d'initialisation du TouchScreen
void Init_Bouton(void);         //Fonction d'initalisation des boutons
void Affichage_valeurs(void);   //Fonction d'affichage de la tension et du courant
void Action_bouton(void);       //Fonction d'action à l'appui des bouton
//////////////////////////////////////////PROTOTYPE////////////////////////////////////////////////////




int main()
{
    
    
    
   Init_TS();           //Appel de la fonction d'initialisation du TouchScreen
   
   Init_Bouton();       //Appel de la fonction d'initialisation des boutons
    
   //lcd.DrawBitmap(20,20,(uint8_t*)"local\stop.bmp");
    
    
    while(1) {
        
        
        Affichage_valeurs();    //Appel de la fonction pour calculer et afficher sur l'ecran LCD la tension et le courant
        
        ts.GetState(&TS_State); //Récupération de l'état du TouchScreen
         
        if (TS_State.touchDetected) {    //Si touché détecté
           
            
            for (idx = 0; idx < TS_State.touchDetected; idx++) {   //Récupération de l'axe x et y 
                x = TS_State.touchX[idx];                          //Récupération de l'axe x
                y = TS_State.touchY[idx];                          //Récupération de l'axey 
            }
        
        
        Action_bouton();        //Appel de la fonction qui permet d'effectuer l'action des boutons Start et Stop
      
           
        }
    }
}







///////////////////////////////////////Initialisation TouchScreen//////////////////////////////////
void Init_TS(void) 
{
  lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"Capteur courant DEMO", CENTER_MODE); //Affichage titre projet
   
    wait(4); //Temporisation

    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());       //Acquisition des dimensions de l'écran
    
    if (status != TS_OK) {  //Si TouchScreen différent de OK
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);  //Afficher Etat fail
    } else {    //Sinon
        lcd.Clear(LCD_COLOR_GREEN);
        lcd.SetBackColor(LCD_COLOR_GREEN);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);    //Afficher Etat OK
    }   
    
    wait(1); //Temporisation


}
///////////////////////////////////////Initialisation TouchScreen//////////////////////////////////



///////////////////////////////////////Initialisation Bouton///////////////////////////////////////
void Init_Bouton(void)
{
    
    

    lcd.Clear(LCD_COLOR_WHITE); //Effacer l'affichage actuel
    lcd.SetFont(&Font16);
    lcd.SetBackColor(LCD_COLOR_WHITE);   //Background en bleu
    
    
    
        
    
    lcd.SetTextColor(LCD_COLOR_RED);    //Dessine le premier bouton en rouge
    lcd.DrawCircle(350, 230, 30);       //Dessine le bouton (x,y,rayon)
    lcd.FillCircle(350, 230, 30);       //Remplis le bouton (x,y,rayon)
    
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.DrawCircle(150, 230, 30);
    lcd.FillCircle(150, 230, 30);
    
    lcd.SetTextColor(LCD_COLOR_BLUE);  //Remettre l'écriture du texte en blanc
    
    lcd.DrawRect(140,100,215,60);
    sprintf((char*)text, "Capteur de courant");       //Efface l'affichage de l'état Start
    lcd.DisplayStringAt(155, LINE(3), (uint8_t *)&text, LEFT_MODE); 


}
///////////////////////////////////////Initialisation Bouton//////////////////////////////////



///////////////////////////////////////Affichage des valeurs//////////////////////////////////
void Affichage_valeurs(void)
{
    
 if(active==1) //Si flag à 1
        {
            
            tension = 0.8*tension + 0.2*anal.read()*3.3; //Acquisition de la tension en entrée du port A4
        
            amp = (23.307*tension) - (38.521);                     //Calcul du courant à l'aide de l'équation generée sur excel //y = 23.307x - 38.521
            
        }
        
        if(amp<0)
        {
         
           /*sprintf((char*)text, "      ");           //Affichage de l'état Start
           lcd.DisplayStringAt(220, LINE(13), (uint8_t *)&text, LEFT_MODE);*/
         
            
         
            sprintf((char*)text, "Calibration");           //Affichage de l'état Start
            lcd.DisplayStringAt(200, LINE(11), (uint8_t *)&text, LEFT_MODE);
        }
        else
        {
         
         
         sprintf((char*)text, "            ");     //Efface l'affichage de l'état Stop
         lcd.DisplayStringAt(200, LINE(11), (uint8_t *)&text, LEFT_MODE);
         
          /*sprintf((char*)text, "Mesure");           //Affichage de l'état Start
           lcd.DisplayStringAt(220, LINE(13), (uint8_t *)&text, LEFT_MODE);*/
         
         lcd.ClearStringLine(8);
         lcd.DrawRect(140,100,215,60);
         sprintf((char*)text, "Intensite : %.2f",amp);
         lcd.DisplayStringAt(150, LINE(8),(uint8_t *)&text, LEFT_MODE);   
        }
        
        
        
         lcd.ClearStringLine(7);    //Effacement de la ligne pour actualiser la valeur
         lcd.DrawRect(140,100,215,60);
         sprintf((char*)text, "Tension   : %.2f",tension);      //Ecriture de la valeur
         lcd.DisplayStringAt(150, LINE(7),(uint8_t *)&text, LEFT_MODE);     //Affichage de la valeur
                  
        
         

         wait(0.3);     //Temporisation


}
///////////////////////////////////////Affichage des valeurs//////////////////////////////////




///////////////////////////////////////Action des boutons//////////////////////////////////
void Action_bouton(void)
{
    
 if ((TS_State.touchDetected) & (x>320&x<380) & (y>200&y<260)) {    //Quand touche détectée à la position du bouton Stop
           
           sprintf((char*)text, "      ");       //Efface l'affichage de l'état Start
           lcd.DisplayStringAt(220, LINE(13), (uint8_t *)&text, LEFT_MODE);    
           
           sprintf((char*)text, "Arret");        //Affichage de l'état Stop
           lcd.DisplayStringAt(220, LINE(13), (uint8_t *)&text, LEFT_MODE);
           
           lcd.ClearStringLine(8);              //Mise à 0  du courant quand la lecture est stoppée
           sprintf((char*)text, "Intensite : %.2f",amp);                    
           lcd.DisplayStringAt(150, LINE(8),(uint8_t *)&text, LEFT_MODE);
           amp = 0;
           
           lcd.ClearStringLine(7);              //Mise à 0  de la tension quand la lecture est stoppée
           sprintf((char*)text, "Tension   : %.2f",tension);
           lcd.DisplayStringAt(150, LINE(7),(uint8_t *)&text, LEFT_MODE);
           tension = 0;
           
           
           active=0;    //mise à 0 du drapeau

           
           lcd.SetTextColor(LCD_COLOR_BLUE);
        }
           
        else if((TS_State.touchDetected) & (x>130&x<180) & (y>200&y<260) ) {    //Quand touche détectée à la position du bouton Start
         
           sprintf((char*)text, "     ");     //Efface l'affichage de l'état Stop
           lcd.DisplayStringAt(220, LINE(13), (uint8_t *)&text, LEFT_MODE);
           
          
           
            //active=1;    //mise à 1 du drapeau
            
        
           
         
           sprintf((char*)text, "Mesure");           //Affichage de l'état Start
           lcd.DisplayStringAt(220, LINE(13), (uint8_t *)&text, LEFT_MODE);
           
          active=1;    //mise à 1 du drapeau
           
           

           lcd.SetTextColor(LCD_COLOR_BLUE);
         }



}
///////////////////////////////////////Action des boutons//////////////////////////////////










