#include "mbed.h"
#include "BLEDevice.h"
#include "AE_KXSD9.h"
#include "nRF51822n.h"

#define ADDR_W 0x30
#define ADDR_R 0x31

#define DBG 1
#define NEED_CONSOLE_OUTPUT 1 /* Set this if you need debug messages on the console;
                               * it will have an impact on code-size and power consumption. */

#if NEED_CONSOLE_OUTPUT
Serial  pc(USBTX, USBRX);
#define DEBUG(...) { pc.printf(__VA_ARGS__); }
#else
#define DEBUG(...) /* nothing */
#endif /* #if NEED_CONSOLE_OUTPUT */

BLEDevice   ble;

//AE_KXSD9    kxsd9(PinName sda, PinName scl, int addr1, int addr2); /* KXSD9 */
AE_KXSD9 i2c(p22, p20, ADDR_W, ADDR_R); //sda, scl, addr_w, addr_r


static const char DEVICENAME[] = "HRM1017";
static volatile bool  triggerSensorPolling = false;

const uint8_t KXSD9_service_uuid[] = {
    0x31,0x27,0x00,0xE2,0xE7,0x98,
    0x4D,0x5C,
    0x8D,0xCF,
    0x49,0x90,0x83,0x32,0xDF,0x9F
};

const uint8_t KXSD9_Characteristic_uuid[] = {
    0xFF,0xA2,0x8C,0xDE,0x65,0x25,
    0x44,0x89,
    0x80,0x1C,
    0x1C,0x06,0x0C,0xAC,0x97,0x67
};


uint8_t thermTempPayload[sizeof(double)*4] = {0,0,0,0};

GattCharacteristic  ControllerChar (KXSD9_Characteristic_uuid,
                                        thermTempPayload, (sizeof(double) * 4), (sizeof(double) * 4),
                                        GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);

GattCharacteristic *ControllerChars[] = { &ControllerChar, };
GattService         KXSD9Service(KXSD9_service_uuid, ControllerChars, sizeof(ControllerChars) / sizeof(GattCharacteristic *));

static Gap::ConnectionParams_t connectionParams;

void updateValue();

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)    // Mod
{
    
    DEBUG("Disconnected handle %u, reason %u\n", handle, reason);
    DEBUG("Restarting the advertising process\n\r");
    ble.startAdvertising();
}

void onConnectionCallback(Gap::Handle_t handle, const Gap::ConnectionParams_t *params)   //Mod
{

    DEBUG("connected. Got handle %u\r\n", handle);

    connectionParams.slaveLatency = 1;
    if (ble.updateConnectionParams(handle, &connectionParams) != BLE_ERROR_NONE) {
        DEBUG("failed to update connection paramter\r\n");
    }
}

void periodicCallback(void)
{
    //oneSecondLed = !oneSecondLed; /* Do blinky on LED1 while we're waiting for BLE events */

    /* Note that the periodicCallback() executes in interrupt context, so it is safer to do
     * heavy-weight sensor polling from the main thread. */
    triggerSensorPolling = true;
}
/**************************************************************************/
/*!
    @brief  Program entry point
*/
/**************************************************************************/
int main(void)
{
    //pc.baud(115200);

#if DBG
        pc.printf("Start\n\r");
#endif
    Ticker ticker;
    ticker.attach(periodicCallback, 1);
    
    i2c.init();
    
    ble.init(); 
    ble.onDisconnection(disconnectionCallback);
    ble.onConnection(onConnectionCallback);
    
    ble.getPreferredConnectionParams(&connectionParams);
    
    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED  | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME, (const uint8_t *)DEVICENAME, sizeof(DEVICENAME));
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                    (const uint8_t *)KXSD9_service_uuid, sizeof(KXSD9_service_uuid));

    ble.setAdvertisingInterval(160); /* 100ms; in multiples of 0.625ms. */
    ble.startAdvertising();

    ble.addService(KXSD9Service);

    for(;;) {
        if (triggerSensorPolling) {
            triggerSensorPolling = false;
            updateValue();
        } else {
            ble.waitForEvent();
        }
    }
}

double Judge_state(double a[128])
 {
     double state=0;
     int i;
     double sum0=0;
     double sum1=0;
     double avg=0;
     double M=0;
     int n=128;
     double LowChecker=1000;//区分静止和行走的界限
     double HighChecker=10000;//区分行走和跑步的界限
     for(i=0;i<n;i++)
     {
         sum0+=a[i];          
     }
     avg=sum0/n;
     for(i=0;i<n;i++)
     {
         sum1+=abs(a[i]-avg);
     }
     M=sum1/n;
     if(M>=0&&M<LowChecker)
     {
         state=1.0;
     }
     else if(M>=LowChecker&&M<HighChecker)
     {
         state=2.0;
     }
     else state=3.0;
     return state;
 }

void updateValue(void){

    double x = 0.0;
    double y = 0.0;
    double z = 0.0;
    double s=0;
    int i=0;
    double s_a; //合成的一维加速度
    double a[128];//用于存放128个一维加速度取样值
    i2c.read_xyz(&x, &y, &z);
    //pc.printf("%.3lf,%.3lf,%.3lf\r\n", x, y, z);
    
    s_a=sqrt(x*x+y*y+z*z);
    a[i]=s_a-55602;
    i=i+1;
    if(i==127)
    {
        s=Judge_state(a);
        i=0;
        //printf("Dx=:%lf\r\n",x);
        //printf("Dy=:%lf\r\n",y);
        //printf("Dz=:%lf\r\n",z);
        //printf("Dz=:%lf\r\n",s);
        }

    
    memcpy(thermTempPayload+sizeof(double)*0, &x, sizeof(x));

    memcpy(thermTempPayload+sizeof(double)*1, &y, sizeof(y));
    
    memcpy(thermTempPayload+sizeof(double)*2, &z, sizeof(z));
    
    memcpy(thermTempPayload+sizeof(double)*3, &s, sizeof(s));
    
    pc.printf("%.3lf,%.3lf,%.3lf,%.3lf\r\n",
                        *(double*)&thermTempPayload[sizeof(double)*0],
                        *(double*)&thermTempPayload[sizeof(double)*1],
                        *(double*)&thermTempPayload[sizeof(double)*2],
                        *(double*)&thermTempPayload[sizeof(double)*3]);
    ble.updateCharacteristicValue(ControllerChar.getValueAttribute().getHandle(), thermTempPayload, sizeof(thermTempPayload));             //Mod
}
