#include "mbed.h"
#include "JPEGCamera.h"
#include "RHT03.h"
#include "GPS.h"


DigitalOut myled1(LED1); //show successful picture was taken
DigitalOut myled2(LED2); //show end of sequence
DigitalOut myled3(LED3); //show picture take failed
DigitalOut myled4(LED4); //show camera is not ready

Serial pc(USBTX, USBRX); // tx, rx
/*Xbee Start*/

Serial XBee(p13, p14);


// SET THIS.
// Create an instance of the GPS object. You will need to
// set p27 to whichever Serial RX pin you have connected
// your GPS module to.
GPS gps(NC,p27);

char rmc[GPS_BUFFER_LEN];
char gga[GPS_BUFFER_LEN];
char vtg[GPS_BUFFER_LEN];
char ukn[GPS_BUFFER_LEN];

// 0.1 second flash of LED2
DigitalOut led2(LED2);
Timeout t2;
void t2out(void)
{
    led2 = 0;
}
void blip2(void)
{
    led2 = 1;
    t2.attach(&t2out, 0.1);
}

// 0.1 second flash of LED3
DigitalOut led3(LED3);
Timeout t3;
void t3out(void)
{
    led3 = 0;
}
void blip3(void)
{
    led3 = 1;
    t3.attach(&t3out, 0.1);
}

// 0.1 second flash of LED4
DigitalOut led4(LED4);

Timeout t4;
void t4out(void)
{
    led4 = 0;
}
void blip4(void)
{
    led4 = 1;
    t4.attach(&t4out, 0.1);
}
/////////////////////////////////////////////////////////////

int main()
{

   GPS_Time q1;
    // SET THIS.
    // Ensure you set the baud rate to match your serial
    // communications to your PC/Max/Linux host so you
    // can read the messages.
    pc.printf("setting the PC baud rate");
    pc.baud(9600);
    

    // Tell MODGPS "we want copies of the NMEA sentences". When a callback
    // is made our buffers will contain a copy of the last received sentence
    // before it was processed/destroyed.
    gps.setRmc(rmc);
    gps.setGga(gga);
    gps.setVtg(vtg);
    gps.setUkn(ukn);


    // SET THIS.
    // Most GPS modules use 9600,8,n,1 so that's what
    // we default to here. Ensure your GPS module matches
    // this, otherwise set it to match.
    pc.printf("setting the GPS baud rate");
    gps.baud(9600);
    gps.format(8, GPS::None, 1);

    // OPTIONAL
    // If you GPS has a 1 pulse per second output you can
    // connect it to an Mbed pin. Here you specify what pin
    // and on what "edge" teh signal is active. If your GPS
    // module has a rising edge at the one second point then
    // use GPS::ppsRise
#ifdef PPSPIN
    gps.ppsAttach(PPSPIN, GPS::ppsFall);
#endif

    // Sample of a callback to a function when the 1PPS activates.
    // For this example, we flash LED2 for 0.1 second.
    gps.attach_pps(&blip2);

    // Sample of a callback to a function when a NMEA GGA message is recieved.
    // For this example, we flash LED2 for 0.1 second.
    gps.attach_gga(&blip3);

    // Sample of a callback to a function when a NMEA RMC message is recieved.
    // For this example, we flash LED2 for 0.1 second.
    gps.attach_rmc(&blip4);



    // Camera Code
    pc.printf("Loading camera module");
    JPEGCamera camera(p9, p10); // TX, RX
    LocalFileSystem local("local"); //save images on mbed
    camera.setPictureSize(JPEGCamera::SIZE320x240);
    pc.printf("getting ready for the while loop!");
    int counter = 0;
    while(counter <1 ) {
    counter++;
        // GPS Code
      pc.printf("Turning inside the loop()");
        // Every 3 seconds, flip LED1 and print the basic GPS info.
        pc.printf("hello GPS");
        wait(3);
        myled1 = 1;

        // Demonstrate how to find out the GPS location co-ords.
        pc.printf("Method 1. Lat = %.4f ", gps.latitude());
        pc.printf("Lon = %.4f ", gps.longitude());
        pc.printf("Alt = %.4f ", gps.altitude());

        // Gran a snapshot of the current time.
        gps.timeNow(&q1);
        pc.printf("%02d:%02d:%02d %02d/%02d/%04d\r\n",
                  q1.hour, q1.minute, q1.second, q1.day, q1.month, q1.year);

        // Alternative method that does the same thing.
        pc.printf("Method 2. Lat = %.4f ", gps.latitude());
        pc.printf("Lon = %.4f ", gps.longitude());
        pc.printf("Alt = %.4f ", gps.altitude());

        GPS_Time *q2 = gps.timeNow();
        pc.printf("%02d:%02d:%02d %02d/%02d/%04d\r\n\n",
                  q2->hour, q2->minute, q2->second, q2->day, q2->month, q2->year);
        delete(q2);
        myled1 = 0;
     

        ////////////////////

        //Temperature Sensor Code
        pc.printf("hello TEMP");
        int done=0;
        float temp,hum;

        RHT03 humtemp(p24); //Initalise the RHT03 (change pin number to the pin its connected to)

        while(!done) { //Loop keeps running until RHT03 is read succesfully
            wait(2); //Needed to make sure the sensor has time to initalise and so its not polled too quickly
            if(humtemp.readData() == RHT_ERROR_NONE) done=1; //Request data from the RHT03
        }

        temp = humtemp.getTemperatureC(); //Gets the current temperature in centigrade
        hum = humtemp.getHumidity(); //Gets the current humidity in percentage

        pc.printf("Temperature is %f C \r\n",temp);
        pc.printf("Humidity  is %f % \r\n",hum);
        wait(3);
        /////////////////////////////////////////////////
    
        //camera Code
        Timer timer;
        pc.printf("starting timer...");
        timer.start();
        pc.printf("hello CAMERA");
        for (int i = 1; i < 5; i++) {
            if (camera.isReady()) {
                char filename[32];
                sprintf(filename, "/local/pict%03d.jpg", i);
                printf("Picture: %s ", filename);
                if (camera.takePicture(filename)) {
                    while (camera.isProcessing()) {
                        camera.processPicture();
                    }
                    myled1 = 1; //show successful picture was taken
                    wait(2.0);
                    myled1 = 0;
                } else {
                    printf("take picture failed\n");
                    myled3 = 1; //show picture take failed
                    wait(2.0);
                    myled3 = 0;
                }
            } else {
                printf("camera is not ready\n");
                myled4 = 1; //show camera is not ready
                wait(2.0);
                myled4 = 0;
            }
        }
        myled2 = 1; //show end of sequence
        wait(2.0);
        myled2 = 0;
        printf("time = %f\n", timer.read());
        ////////////////////////////////////////////////////

        //Xbee Code

        pc.printf("i'm Sending..");
        XBee.printf("Hello");
        wait(1.0);

        /////////////////////////////////////////////
        

    }
}