#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPServer.h"
#include "C12832_lcd.h" // Include for LCD code

C12832_LCD lcd; //Initialize LCD Screen


EthernetInterface eth;

    static const char*          mbedIp       = "192.168.137.2";  //IP
    static const char*          mbedMask     = "255.255.255.0";  // Mask
    static const char*          mbedGateway  = "192.168.137.1";    //Gateway
   
int main()
{
    printf("********* PROGRAM START ***********\r\n");
    printf("EthernetInterface Setting up...\r\n");
    //if(eth.init()!=0) {                             //for DHCP Server
        if(eth.init(mbedIp,mbedMask,mbedGateway)!=0) { //for Static IP Address
        printf("EthernetInterface Initialize Error \r\n");
        return -1;
    }
    if(eth.connect()!=0) {
        printf("EthernetInterface Connect Error \r\n");
        return -1;
    }
    printf("IP Address is %s\r\n", eth.getIPAddress());
    printf("NetMask is %s\r\n", eth.getNetworkMask());
    printf("Gateway Address is %s\r\n", eth.getGateway());
    printf("Ethernet Setup OK\r\n");

    HTTPServerAddHandler<SimpleHandler>("/"); //Default handler
    lcd.locate(0,0);
    lcd.printf("IP:%s",eth.getIPAddress());
    HTTPServerStart(80);
}


