#include "mbed.h"
#include "EthernetInterface.h"
#include "LM75B.h"
#include "HTTPClient.h"
#include "C12832_lcd.h" // Include for LCD code

LM75B tmp(p28,p27); // temperature sensor
char* Server = "http://192.168.1.108/IoT/api_update.php";
char* id = "1";

char buffer[256];
C12832_LCD lcd; //Initialize LCD Screen


void ethernetSetup(){
   static const char*          mbedIp       = "192.168.137.2";  //IP
   static const char*          mbedMask     = "255.255.255.0";  // Mask
   static const char*          mbedGateway  = "192.168.137.1";    //Gateway

EthernetInterface eth;
  //  eth.init(); //Use DHCP
    eth.init(mbedIp,mbedMask,mbedGateway); 
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress()); // display at terminal
    lcd.printf("IP address: %s \n",eth.getIPAddress()); // display LCD screen
    
    }
    
void sendToServer(){
    HTTPClient http;
    buffer[0] = 0;
    sprintf(buffer,"%s?id=%s&data=%2f",Server,id,tmp.read());
    printf("Send to %s\r\n", buffer);
    http.get(buffer, buffer , 10); // Execute the URL of urlBuffer
   // lcd.printf("Send: %s \n",buffer);
    }

int main() {
    ethernetSetup();
      sendToServer();
    while(1) {
           wait(0.5);
          sendToServer();
           wait(0.5);
        }
}
