#include "mbed.h"                                                                   // Include files and define parameters.
#include "Adafruit_ADS1015.h"
#include <vector>
#include <string>
#define EEPROM_adr (0xA0)//8Bit address for I2C to EEPROM
using namespace std;

I2C i2c(PB_9, PB_8);                                                  // I2C for sensorplate.
Serial usb_serial(SERIAL_TX, SERIAL_RX);                                            // tx, rx

int i2c__frequency = 100000;                                                              // I2C Frequency.
int baud_rate = 115200;                                                             // Baud rate.
Timer timer;

DigitalOut myled(LED1);

//EEPROM
//              Device      Code  Chip   Enable  RW
//Bit           b7 b6 b5 b4 b3    b2     b1      b0
//Device Select 1  0  1  0  E2    E1     E0      RW
// E0,E1 and E2 are to identify device
//Writing EEPROM through I2C
void EEPROM_ready(){
    int ack;
    uint8_t waddr[2];
    waddr[0] = 0;
  // Wait end of write
  do {
       ack = i2c.write(EEPROM_adr,(char *)waddr,0);
  } while(ack != 0);
}

void EEPROM_write(uint32_t Wreg, int8_t EEPROM_dat){
    int ack;
    uint8_t cmd[3];
    cmd[0] = (uint8_t) (Wreg >> 8); //Address MSB
    cmd[1] = (uint8_t) Wreg;        //Address LSB
    cmd[2] = (uint8_t) EEPROM_dat;       //Data
    
    ack=i2c.write(EEPROM_adr,(char*)cmd,sizeof(cmd));
    if(ack != 0) {
    usb_serial.printf("ERRORwrite\r\n");
    }
    // Wait end of write
    EEPROM_ready();
}

void EEPROM_read(uint32_t Wreg, int8_t& EEPROM_dat){
    int ack;
    uint8_t cmd[2];
    
    cmd[0] = (uint8_t) (Wreg >> 8); //Address MSB
    cmd[1] = (uint8_t) Wreg;        //Address LSB
    
    ack = i2c.write(EEPROM_adr,(char*)cmd,2,true);
    if(ack != 0) {
    usb_serial.printf("ERRORfakewrite\r\n");
    }
    ack=i2c.read(EEPROM_adr,(char*)&EEPROM_dat,sizeof(EEPROM_dat));
    if(ack != 0) {
    usb_serial.printf("ERRORread\r\n");
    } 
}

int main(){

    i2c.frequency(i2c__frequency);                                    // Set frequency for i2c connection to sensorplate (variable is declared in config part).
    usb_serial.baud(baud_rate);                                                     // Set serial USB connection baud rate (variable is declared in config part).
    
    uint32_t Wreg= 10;
    int8_t EEPROM_dat=56;
    int8_t result=0;
    
    usb_serial.printf("Startooo\r\n");
    EEPROM_write(Wreg,EEPROM_dat);
    EEPROM_read(Wreg,result);
    usb_serial.printf("EEPROMdata = %d\r\n", result); 
}