#include "helpers.h"
#include "stm32f103c8t6.h"
#include "mbed.h"
#include <leitor_rfid.h>
#include <string.h>

// Lista de possiveis botoes apertados.

typedef enum PainelButton{
    BUTTON_none,
    BUTTON_forward,
    BUTTON_backward,
    BUTTON_headlights
}PainelButton;
// estados possiveis do farol
typedef enum Farol{
    FAROL_off = 0,
    FAROL_on   
}Farol;
/* 
Struct contendo informacoes sobre o estado. 
    'pressed_button': utilizado para aferir se algum botao esta sendo acionado
    'farol': utilizado para armazenar o estado do farol, se ligado ou desligado
*/
typedef struct Painel{
    PainelButton pressed_button;    
    Farol farol;
}Painel;

typedef struct CanStatus{
    bool can_bms_ok;
    bool can_inversor_ok;
}CanStatus;

typedef struct FalhasEAlarmes{
    uint16_t falha_weg; 
    uint16_t falha_bms;
    uint16_t falha_mca;   
    uint16_t alarme_weg;
    uint16_t alarme_mca;
}FalhasEAlarmes;

enum CAN_ENVIO{
    CAN_ID_acionamentos =     0x0CF00003,
    CAN_ID_falhas_e_alarmes = 0x0CF10003,    
    CAN_ID_id_usuario =       0x0CF20003,
    CAN_ID_ESTADO_DO_CARRO =  0x0CF30003,
};

enum CAN_RECEBIMENTO{
    CAN_ID_WEG_FALHAS_E_ALARMES = 0x0CF80002,
    CAN_ID_WEG_SENTIDO_DE_MOVIMENTO = 0x0CF10002,
    CAN_ID_BMS_FALHAS_E_ALARMES = 0x186455F4,
    CAN_ID_BMS_SOC = 0x186555F4,
};
// Parametros de leds e PWM
const uint8_t leds_pwm_period = 5;
const int buzzer_period_us = 500;

// Duty cycle para saidas pwm conforme estados
const float D_ON_LED_FRENTE_RE = 0.8;
const float D_OFF_LED_FRENTE_RE = 0.001;
const float D_ON_LED_HEADLIGHT = 0.8;
const float D_OFF_LED_HEADLIGHT = 0.001;
const float D_BUZZER_STD = 0.5;

// Definicoes de intensidade de leds
const float led_max = 1;
const float led_strong = 0.8;
const float led_average = 0.5;
const float led_weak = 0.1;

//Parametro para debounce dos botoes
const uint8_t BUTTON_COOLDOWN_COUNTER_RESET = 6;
// referente ao polling de botoes
const int n_amostras = 5;
const int button_treshold = 4;
const float button_polling_period = 0.010;

const uint8_t VELOCIDADE_CARRO_PARADO = 3;
const uint16_t SOC_BAIXA_CARGA = 10;
const uint16_t CHARGE_CURRENT_CHARGING = 2;
// Prototipos das funcoes

void checkButtons();
void beepBuzzer(int ms_duration);
void initPWMs();
bool setLedsAndRelays(PainelButton button);
void turnOnSetup();
void turnOffSetup();
void enableAntenna();
void setRfInterrupt();
void handlePressedButton();
void enviaEstadoDeAcionamentosFalhasEAlarmesViaCAN();
void buzzWrongCard();
void getMsg();
int sendCanMsg(int id=0, const char *data=0, char len=8, CANType type=CANData, CANFormat format=CANExtended);
void populaArrayFalhasEAlarmes(char* array, size_t n);
void tentaDesligarCarro();
void tentaLigarCarro();
void afirmaFalha(int flag_not_ok, uint16_t DTC_da_falha, volatile uint16_t* falha);
int sendCanCarState();
