#include "main.h"
/*
192.168.0.59
conta> pi
senha> raspberry
    
Feito para placa MCA versao PECI091BA
    
Utiliza polling para afericao do estado dos botoes de acionamento frente/re
utiliza polling para leitura do cartao

Funcionalidades:

    Leitura de Cartao
    Botões: Frente/Re/Farol
    Acionamentos: KSI, Frente, Re, Farol    
    
Codigo antecessor: C_005_DC
    Adicoes:
        Remocao da leitura de dados do bms

TO DO:

DONE:

        
*/


// Arrays que armazenam os estados dos botoes
uint16_t in_frente_states[n_amostras]= {0};
uint16_t in_re_states[n_amostras]= {0};
uint16_t in_farol_states[n_amostras]= {0};
// contador utilizado para debounce, deixar os botoes impossivel de serem acionados
uint8_t button_cooldown_counter = 0;

DigitalIn in_frente(PB_5);
DigitalIn in_re(PB_6);
DigitalIn in_farol(PB_7);
DigitalIn in_freio_de_estacionamento(PB_4);

DigitalIn in_12v_charge_confirm(PB_10);

// Indicadores para o usuario
PwmOut     led_forward(PA_8);
PwmOut     led_backward(PA_9);
PwmOut     led_headlight(PA_11);
PwmOut     buzzer(PB_1);

DigitalOut embedded_led(PC_13);
DigitalOut led_mobilis(PA_4);
DigitalOut led_erro_3(PA_5);
DigitalOut led_erro_2(PA_6);
DigitalOut led_erro_1(PA_7);
DigitalOut led_economia(PB_0);
DigitalOut led_freio_est(PA_10);

DigitalInOut io_seta_e(PB_3);
DigitalInOut io_seta_d(PA_15);

DigitalOut out_KSI(PA_1);
DigitalOut out_frente(PA_2);
DigitalOut out_re(PA_0);
DigitalOut out_farol(PC_15);

volatile static CanStatus can_status = {true,true};
//struct que contem as falhas presentes no carro
volatile static FalhasEAlarmes falhas_e_alarmes = {0,0,0,0,0};
// Struct que contem informacoes sobre o estado do Painel, ver arquivo 'main.h'
volatile static Painel painel = {BUTTON_none,FAROL_off};
volatile uint16_t soc = 0;
volatile uint16_t charge_current = 0;

bool car_is_on = false;
bool car_is_locked = false;
bool battery_is_charging = false;
bool battery_is_charged = false;

// Timer utilizado para polling de botoes
Ticker timer_botoes;
CardReader    rf_chip   (PB_15, PB_14, PB_13, PB_12, PB_11);
CAN can(PB_8,PB_9);

char arr_id_usuario[4] = {0,0,0,0};



int main(void)
{    
    timer_botoes.attach(&checkButtons,button_polling_period);
    rf_chip.init(CRMODE_Polling);    
    can.frequency(250000);
    can.attach(&getMsg);
    initPWMs();
    turnOffSetup();
    out_KSI = 0;
    wait_ms(500);
    
    uint16_t T = 100;
    uint16_t k = 1;
    while(1){ 
        // dt: tempo decorrido
        uint16_t dt = T*k;
        // a cada 100 ms : le cartao, liga/desliga carro de acordo
        if (dt%100 == 0){
            if(!car_is_locked && rf_chip.readCard()){
                if(rf_chip.cardIsValid()){
                    if(car_is_on){
                        tentaDesligarCarro();
                    }else{  
                        tentaLigarCarro();
                        if(car_is_on){
                            k=1;
                        }
                    }                
                }else{
                    //Caso cartao nao seja valido
                    buzzWrongCard();
                }
            }// nao faz nada caso nao haja cartao    
            //processa botao apertado, caso haja                     
            if(car_is_on){        
                handlePressedButton();
            }
        }
        // a cada 500ms: envia mensagens no can bus sobre alarme, falhas e estado dos acionamentos
        if(dt % 500 == 0){
            if(car_is_on){
                enviaEstadoDeAcionamentosFalhasEAlarmesViaCAN();
            }
        }
        
        // This routine is ran 
        if(dt % 1000 == 0){
            bool deve_travar_carro = in_12v_charge_confirm.read() == 1;
            if(deve_travar_carro){                
                if(car_is_on){
                    turnOffSetup();
                    out_KSI = 0;
                }
                // acende certo led   
                car_is_on = false;
                car_is_locked = true;
            }
            bool deve_destravar_carro = car_is_locked && (in_12v_charge_confirm.read() == 0);
            if(deve_destravar_carro){
                car_is_locked = false;
                // apaga certo led
            }
            
            battery_is_charging = (in_12v_charge_confirm.read() == 1) && (charge_current > CHARGE_CURRENT_CHARGING);
            battery_is_charged = (in_12v_charge_confirm.read() == 1) && (charge_current < CHARGE_CURRENT_CHARGING);
            if(battery_is_charging){
                led_mobilis = !led_mobilis;                    
            }else if(battery_is_charged){
                led_mobilis = 1;
            }else if(!car_is_on){
                led_mobilis = 0;
            }
            
            int mensagem_enviada_sucesso = sendCanCarState();
            afirmaFalha(!mensagem_enviada_sucesso, DTC_FALHA_CAN, &(falhas_e_alarmes.falha_mca));            
        }
        // a cada 5s: envia mensagem no can bus contendo id do usuario, 
        if(dt % 5000 == 0){  
            if(car_is_on){
                
                char can_data_uid [4] = {0,0,0,0};
                std::copy(arr_id_usuario, arr_id_usuario+ID_SIZE, can_data_uid);
                sendCanMsg(CAN_ID_id_usuario,can_data_uid,4);                
                                
                // Checa se inversor e BMS estao se comunicando atraves das flags can_inversor_ok e can_bms_ok
                afirmaFalha(!can_status.can_inversor_ok, DTC_FALHA_INVERSOR_CAN, &falhas_e_alarmes.falha_mca);
                afirmaFalha(!can_status.can_bms_ok, DTC_FALHA_BMS_CAN, &falhas_e_alarmes.falha_mca);
                can_status.can_inversor_ok = false;
                can_status.can_bms_ok = false;
                
                bool alarmes_existem = falhas_e_alarmes.alarme_mca ||  falhas_e_alarmes.alarme_weg;                                
                bool falhas_existem = falhas_e_alarmes.falha_mca || falhas_e_alarmes.falha_weg || falhas_e_alarmes.falha_bms;                

                led_erro_1 = falhas_existem;
                led_erro_2 = alarmes_existem;
                led_erro_3 = soc < SOC_BAIXA_CARGA;

            }                      
        }
        // a cada 10 s: reseta leitor de cartoes
        if(dt > 10000){
            int leitor_reset_sucesso = rf_chip.init(CRMODE_Polling);
            afirmaFalha(!leitor_reset_sucesso, DTC_FALHA_LEITOR, &falhas_e_alarmes.falha_mca);
            k=1;
        }
        k++;
        wait_ms(100);
    }    
}

/* Caso o flag acuse uma falha (com DTC 'DTC_da_falha'), registra ela no ponteiro *falha 
            caso nao acuse falha, limpa essa falha do ponteiro *falha
*/
void afirmaFalha(int flag_not_ok, uint16_t DTC_da_falha, volatile uint16_t* falha){
    if(flag_not_ok){
        *falha = DTC_da_falha;
    }else if(*falha == DTC_da_falha){
        *falha = 0;
    }
}

// Executado ao passar o cartao quando carro esta' desligado
void tentaLigarCarro(){
    turnOnSetup();
    car_is_on = true;     
    // copia o cartao lido para array 'arr_id_usuario', que sera enviado pelo barramento CAN
    std::copy(rf_chip.last_valid_card, rf_chip.last_valid_card+ID_SIZE, arr_id_usuario);
    sendCanMsg(CAN_ID_id_usuario,arr_id_usuario,4);
    painel.pressed_button=BUTTON_none; 
}
// Executado ao passar o cartao quando carro esta' ligado
void tentaDesligarCarro(){
    // Verifica se cartao lido e' o mesmo que foi utilizado para ligar o carro
    bool card_matches_previous = memcmp(rf_chip.last_valid_card, arr_id_usuario, sizeof(rf_chip.last_valid_card)) == 0;
    if(card_matches_previous){
        turnOffSetup();
        car_is_on = false;        
        for(int i = 0; i < 15; i ++){
            sendCanCarState();
            wait_ms(1000);
        }        
        out_KSI = 0;
        //Limpa informacao sobre id do usuario
        memset(arr_id_usuario, 0, sizeof(arr_id_usuario));
    }else{
        buzzWrongCard();  
    }
}
// Executado pelo main
void enviaEstadoDeAcionamentosFalhasEAlarmesViaCAN(){     
    // Prepara arrays para envio
    char arr_falhas_e_alarmes[8];
    populaArrayFalhasEAlarmes(arr_falhas_e_alarmes, 8);    
    const uint8_t ARR_SIZE = 4;
    char arr_acionamentos[ARR_SIZE] = {out_frente.read(), out_re.read(), out_farol.read(), in_freio_de_estacionamento.read()};
    // Envia as mensagens CAN
    sendCanMsg(CAN_ID_falhas_e_alarmes,arr_falhas_e_alarmes);
    sendCanMsg(CAN_ID_acionamentos,arr_acionamentos,ARR_SIZE);
}

void populaArrayFalhasEAlarmes(char* array, size_t n){
    // Arrays intermediarios para armazenar DTCs
    uint16_t can_falhas_array[2] = {0,0};
    uint16_t can_alarmes_array[2] = {0,0};     
    if(falhas_e_alarmes.falha_mca != 0){
        arrayPush(can_falhas_array, falhas_e_alarmes.falha_mca, 2);
    }
    if(falhas_e_alarmes.falha_bms != 0){
        arrayPush(can_falhas_array, falhas_e_alarmes.falha_bms, 2);
    }
    if(falhas_e_alarmes.falha_weg != 0){
        arrayPush(can_falhas_array, falhas_e_alarmes.falha_weg, 2);
    }
    if(falhas_e_alarmes.alarme_mca != 0){
        arrayPush(can_alarmes_array, falhas_e_alarmes.alarme_mca, 2);
    }
    if(falhas_e_alarmes.alarme_weg != 0){
        arrayPush(can_alarmes_array, falhas_e_alarmes.alarme_weg, 2);
    }
    char array_preparado[] = {can_falhas_array[0]&0xFF, can_falhas_array[0]>>8, can_falhas_array[1]&0xFF, can_falhas_array[1]>>8,
                            can_alarmes_array[0]&0xFF, can_alarmes_array[0]>>8, can_alarmes_array[1]&0xFF, can_alarmes_array[1]>>8};
    std::copy(array_preparado,array_preparado+8, array);
}
////////////////////// BEGIN CAN /////////////////////////////////////////////
/* Funcao chamada sempre que uma mensagem chega no barramento CAN
    obs: Roda concorrentemente com o main!!! 
*/

int sendCanCarState(){
    
    char estados_do_carro[8] = {car_is_on, !car_is_on, in_12v_charge_confirm.read(), battery_is_charging, battery_is_charged, 0x00, 0x00, 0x00};
    return sendCanMsg(CAN_ID_ESTADO_DO_CARRO,estados_do_carro);    
}

void getMsg(){
    CANMessage msg;
    if(!can.read(msg)){
        return;
    }
    switch(msg.id){
        case CAN_ID_WEG_FALHAS_E_ALARMES:
            falhas_e_alarmes.falha_weg =  converteDTCWeg(msg.data[1]<<8 | msg.data[0]);
            falhas_e_alarmes.alarme_weg = converteDTCWeg(msg.data[3]<<8 | msg.data[2]);
            can_status.can_inversor_ok = true;
            break;
       case CAN_ID_BMS_FALHAS_E_ALARMES:
            falhas_e_alarmes.falha_bms = converteDTCBms(msg.data[5]<<8 | msg.data[4]);        
            can_status.can_bms_ok = true;
            break;
        case CAN_ID_BMS_SOC:
            { // Chaves utilizadas para que consigamos declarar variaveis dentro de um 'case'
            soc = msg.data[7]<<8 | msg.data[6];             
            charge_current = msg.data[3] << 8 | msg.data[2];
            bool falha_no_circ_de_carga = (soc < 50) && (charge_current < CHARGE_CURRENT_CHARGING) && (falhas_e_alarmes.falha_bms == 0) && (in_12v_charge_confirm.read() == 1);                
            afirmaFalha(falha_no_circ_de_carga, DTC_FALHA_CIRCUITO_DE_CARGA, &falhas_e_alarmes.falha_mca);
            }
            break;
        case CAN_ID_WEG_SENTIDO_DE_MOVIMENTO:
            {
            bool frente_inv = msg.data[0];
            bool re_inv = msg.data[2];
            bool divergencia = frente_inv != out_frente.read() || re_inv != out_re.read();
            afirmaFalha(divergencia, DTC_FALHA_DIVERGENCIA_ENTRE_ACIONAMENTOS, &falhas_e_alarmes.falha_mca);
            }
            break; 
        default:
            break;
    }
}

// funcao para envio de mensagem pelo barramento CAN
int sendCanMsg(int id, const char *data, char len, CANType type, CANFormat format)
{
    if(can.tderror() != 0 || can.rderror() != 0){
        can.frequency(250000);
        can.attach(&getMsg);
    }
    int msgSent = can.write(CANMessage(id,data,len,type,format));
    return msgSent;
}
/////////////////////////           END CAN                                ///////////////////////////

/////////////////////////          BEGIN STANDARD IO                       //////////////////////////
// Funcao que processa o botao apertado
void handlePressedButton(){
    //ignora botao apertado caso tenha pouco tempo que um botao tenha sido apertado
    if(button_cooldown_counter > 0 ){
        painel.pressed_button= BUTTON_none;
        button_cooldown_counter --;
    }
    bool estado_mudou = setLedsAndRelays(painel.pressed_button);
    if(estado_mudou){
        beepBuzzer(100);
    }
    // inicializa contador caso botao tenha sido apertado
    if(painel.pressed_button != BUTTON_none){
        button_cooldown_counter = BUTTON_COOLDOWN_COUNTER_RESET;
    }     
     painel.pressed_button= BUTTON_none;
}

/* rotina executada sempre que o carro liga:
    Aciona KSI,
    Pisca todos os LEDS,
    Aciona buzzer por 100 ms
*/
void turnOnSetup(){
    out_KSI = 1;
    out_frente = 0;
    out_re = 0;
    out_farol = 0;
    
    io_seta_e.output();
    io_seta_d.output();

    led_mobilis = 1;
    led_erro_3 = 1;
    led_erro_2=1;
    led_erro_1 =1;
    led_economia =1;
    led_freio_est=1;
    io_seta_e = 1;
    io_seta_d = 1;
    
    led_forward.write(led_max);
    led_backward.write(led_max);
    led_headlight.write(led_max);
    
    beepBuzzer(100);
    wait_ms(300);
    
    led_erro_3 = 0;
    led_erro_2=0;
    led_erro_1 =0;
    led_economia =0;
    led_freio_est=0;
    io_seta_e = 0;
    io_seta_d = 0;
    led_forward.write(led_weak);
    led_backward.write(led_weak);
    led_headlight.write(led_weak);          
    io_seta_e.input();
    io_seta_d.input();
    wait_ms(200);
}


/* rotina executada sempre que o carro desliga:
    Desaciona todos os acionamentos,
    Pisca todos os LEDS,
    Aciona buzzer por 100 ms
    espera 200 ms
    Aciona buzzer por 50 ms
*/
void turnOffSetup(){
    io_seta_e.output();
    io_seta_d.output();
    out_frente = 0;
    out_re = 0;
    out_farol = 0;    
    led_mobilis = 1;
    led_erro_3 = 1;
    led_erro_2=1;
    led_erro_1 =1;
    led_economia =1;
    led_freio_est=1;
    io_seta_e = 1;
    io_seta_d = 1;
    led_forward.write(led_max);
    led_backward.write(led_max);
    led_headlight.write(led_max);    
    
    beepBuzzer(100);  
    wait_ms(300);                
    led_forward.write(0);
    led_backward.write(0);
    led_headlight.write(0);    
    led_mobilis = 0;
    led_erro_3 = 0;
    led_erro_2=0;
    led_erro_1 =0;
    led_economia =0;
    led_freio_est=0;
    io_seta_e = 0;
    io_seta_d = 0;
    io_seta_e.input();
    io_seta_d.input();
    wait_ms(200);    
    beepBuzzer(50);
    wait_ms(500);
}

// Acende leds e aciona reles de acordo com o botao apertado
bool setLedsAndRelays(PainelButton button){
    bool buzz = true;
    switch (button){        
        case BUTTON_forward:
            led_forward.write(D_ON_LED_FRENTE_RE);
            led_backward.write(D_OFF_LED_FRENTE_RE);
            out_frente = 1;
            out_re = 0;           
            break;            
        case BUTTON_backward:
            led_forward.write(D_OFF_LED_FRENTE_RE);
            led_backward.write(D_ON_LED_FRENTE_RE);
            out_frente = 0;
            out_re = 1;           
            break;            
        case BUTTON_headlights:
            if(painel.farol == FAROL_on){
                led_headlight.write(D_OFF_LED_HEADLIGHT);
                painel.farol = FAROL_off;
                io_seta_e = 1;
                out_farol = 0;
            }else{
                led_headlight.write(D_ON_LED_HEADLIGHT);
                painel.farol = FAROL_on;
                out_farol = 1;
            }            
            break;        
        case BUTTON_none:
        default:
            buzz = false;
            break;        
    }   
    return buzz;
}

// Configura o periodo das saidas PWM
void initPWMs(){
    led_forward.period_ms(leds_pwm_period);
    led_backward.period_ms(leds_pwm_period);   
    led_headlight.period_ms(leds_pwm_period); 
    buzzer.period_us(buzzer_period_us);
}

// Acionamento do buzzer
void beepBuzzer(int ms_duration){
    buzzer.write(D_BUZZER_STD);
    wait_ms(ms_duration);      
    buzzer.write(0);
}

void buzzWrongCard(){
    beepBuzzer(100);
    wait_ms(100);
    beepBuzzer(100);
    wait_ms(100);
    beepBuzzer(100); 
}


/* 
Funcao acionada a cada 'button_polling_period' milissegundos em concorrencia com o main
        Se das ultimas 'n_amostras' de afericao de um botao, 
        pelo menos 'button_treshold' delas tiverem sido verdadeiras,
        Considera botao como apertado
    Algoritmo:
        Le o estado do botao
        Empurra esse estado num array
        Caso a soma dos elementos desse array for maior que 'button_treshold'
            e caso o acionamento nao esteja acionado (valido para frente/re):
            considera botao como apertado 
*/
void checkButtons(){
    int frente_state = in_frente.read();
    arrayPush(in_frente_states, frente_state, n_amostras);
    bool frente_pressionado = arraySum(in_frente_states,n_amostras) > button_treshold;
    int re_state = in_re.read();
    arrayPush(in_re_states,re_state,n_amostras);
    bool re_pressionado = arraySum(in_re_states,n_amostras) > button_treshold;    
    if(re_pressionado && frente_pressionado)
    {
        painel.pressed_button = BUTTON_none;
    }else if(frente_pressionado && (out_frente.read() != 1))
    {
        painel.pressed_button = BUTTON_forward;
    }else if(re_pressionado && (out_re.read() != 1))
    {
        painel.pressed_button = BUTTON_backward;    
    }
    int farol_state = in_farol.read();
    arrayPush(in_farol_states,farol_state,n_amostras);
    if(arraySum(in_farol_states,n_amostras)> button_treshold){
        painel.pressed_button = BUTTON_headlights;
    }
}

/////////////////////// END STANDARD IO ////////////////////////////////////