#include <stm32f103c8t6.h>
#include <mbed.h>
#include <MFRC522.h>
#include <algorithm>
#include <lista_de_ids_autorizados.h>

// Constantes para configuracao do modo de funcionamento segundo datasheet
const uint8_t comIEnRegInterruptValue = (1<<7)|(1<<5);
const uint8_t comIEnRegPollingValue = 0x80;
const uint8_t comIrqRegValue = 0x7F;


// lista de modos de funcionamento do cartao
typedef enum CardReaderMode{
    CRMODE_Interrupt = 0, 
    CRMODE_Polling,
}CardReaderMode;

// classe utilizada pelo usuario
class CardReader{
    private: 
        MFRC522 rf_chip;        
    public: 
        // importante ser 'char' para ser compativel com o metodo de envio de mensagem CAN
        char last_valid_card[ID_SIZE];        
        CardReader(PinName mosi,PinName miso,PinName sclk,PinName cs,PinName reset) : rf_chip(mosi,miso,sclk,cs,reset){}
        uint8_t init(CardReaderMode);
        void clearInterrupts();
        void enableAntenna();
        int readCard(); // returns true if successful
        int cardIsValid();    
};