#include <leitor_rfid.h>
/*
    Inicializacao do leitor de cartoes
*/
uint8_t CardReader::init(CardReaderMode mode){
    rf_chip.PCD_Reset();
    //Configuracoes copiadas da biblioteca utilizada no arduino
    // Reseta baud rates
    rf_chip.PCD_WriteRegister(rf_chip.TxModeReg, 0x00);
    rf_chip.PCD_WriteRegister(rf_chip.RxModeReg, 0x00);
    // Reseta ModWidthReg
    rf_chip.PCD_WriteRegister(rf_chip.ModWidthReg, 0x26);    
    // Prossegue com a inicializacao padrao
    rf_chip.PCD_Init();   
    wait_ms(10);   
    // Seleciona o modo de operacao: Polling ou interrupcao
    int comIEnRegValue;
    switch (mode){
        case CRMODE_Interrupt:
            comIEnRegValue = comIEnRegInterruptValue; 
            break;
        case CRMODE_Polling:
            comIEnRegValue = comIEnRegPollingValue;
            break;
        default:
            comIEnRegValue = comIEnRegPollingValue;
            break;
    }
    rf_chip.PCD_WriteRegister(rf_chip.ComIEnReg, comIEnRegValue);
    // Sucesso de inicializacao se da pelo sucesso de leitura de um registrador
    return comIEnRegValue == rf_chip.PCD_ReadRegister(rf_chip.ComIEnReg);
}

/* Funcao necessaria para funcionamento via interrupcao
        Deve ser chamada logo apos processar uma interrupcao, 
        para que o mfrc522 volte o pino de interrupcao para seu valor de repouso (alto)
*/
void CardReader::clearInterrupts(){
    rf_chip.PCD_WriteRegister(rf_chip.ComIrqReg, comIrqRegValue);
    rf_chip.PICC_HaltA();
}
/* Funcao necessaria para funcionamento via interrupcao
        Deve ser chamada periodicamente 
        para que o mfrc522 reative o circuito da antena

*/
void CardReader::enableAntenna(){  
    rf_chip.PCD_WriteRegister(rf_chip.FIFODataReg, rf_chip.PICC_CMD_REQA);
    rf_chip.PCD_WriteRegister(rf_chip.CommandReg, rf_chip.PCD_Transceive);
    rf_chip.PCD_WriteRegister(rf_chip.BitFramingReg, 0x87);      
}

/*
    Avalia se cartao escolhido esta entre os autorizados para uso com o veiculo
*/
int CardReader::cardIsValid(){
    bool card_is_valid = true;
    // Coleta uid do cartao
    uint8_t* card_id = rf_chip.uid.uidByte;
    uint8_t id_database_list_size = sizeof(id_database_list)/sizeof(id_database_list[0]);
    //itera sobre cada um dos cartoes autorizados e os compara com o cartao lido
    for(uint8_t i = 0; i < id_database_list_size ; i++){            
        card_is_valid = true;
        for(uint8_t j = 0; j < ID_SIZE; j++){
            card_is_valid = card_is_valid && (card_id[j] == id_database_list[i][j]);
        }        
        if(card_is_valid){
            //copia id do cartao para atributo 'last_valid_card' do objeto
            std::copy(rf_chip.uid.uidByte,rf_chip.uid.uidByte+ID_SIZE,last_valid_card);
            break;
        }
    }       
    return card_is_valid;    
}


/*
    Tenta ler o cartao, retorna 'true' em caso de sucesso
*/
int CardReader::readCard(){    
    return rf_chip.PICC_IsNewCardPresent() && rf_chip.PICC_ReadCardSerial();
}