#include "helpers.h"

int16_t FindIndex( const uint16_t a[], uint16_t size, uint16_t value )
{
    int16_t index = 0;
    while ( index < size && a[index] != value ){
         ++index;
    }
    return ( index == size ? -1 : index );
}   

uint16_t converteDTCWeg(uint16_t dtc_weg){
    int16_t index = FindIndex(tabela_dtc_weg,sizeof(tabela_dtc_weg)/sizeof(tabela_dtc_weg[0]),dtc_weg);
    if(index == -1){
        return 0x00;
    }
    uint16_t dtc_mobilis = tabela_dtc_weg_mobilis[index];
    return dtc_mobilis;
}

uint16_t converteDTCBms(unsigned char flags){
    uint16_t dtc_mobilis = 0x00;
    if(flags & 1){
        dtc_mobilis = 0xF29;
    }
    if(flags & (1 << 1)){
        dtc_mobilis = 0xF30;
    }
    if(flags & (1 << 4)){
        dtc_mobilis = 0xF31;
    }
    if(flags & (1 << 5)){
        dtc_mobilis = 0xF32;
    }
    if(flags & (1 << 6)){
        dtc_mobilis = 0xF33;
    }    
    if(flags & (1 << 7)){
        dtc_mobilis = 0xF34;
    }
    if(flags & (1 << 8)){
        dtc_mobilis = 0xF41;
    }
    if(flags & (1 << 9)){
        dtc_mobilis = 0xF42;
    }
    return dtc_mobilis;
}

/* 
    Funcao auxiliar para funcao 'checkButtons()'
    Retorna a soma de todos os 'n' elementos de array 'v' de tamanho
*/
uint16_t arraySum(uint16_t* v,uint16_t n){
    uint16_t result = 0;
    for(int i = 0; i<n;i++){
        result += v[i];
    }
    return result;
}

/* 
    Funcao auxiliar para funcao 'checkButtons()'
    Empurra um elemento 'input' no final de um array 'v' de tamanho 'n'
        ou seja:
            Realiza uma rotacao de elementos do array 'v' 
            v[0] some, 
            v[1] vai para v[0]
            v[2] vai para v[1]
            v[n] vai para v[n-1]
            input vai para v[n]
            Insere um elemento 'input' no final de um array 'v' de tamanho 'n'
*/
void arrayPush(uint16_t* v, uint16_t input, uint16_t n){
    for(int i = 0; i<(n-1) ;i++){
        v[i] = v[i+1];
    }
    v[n-1] = input;   
}