#ifndef MBED_SR04_H
#define MBED_SR04_H

#include "mbed.h"

/** SR04 Ultrasonic range finder class
 *
 * Example:
 * @code
 * // Print measured distance
 *
 * #include "mbed.h"
 * #include "SR04.h"
 *
 * SR04 sr04(PTD3,PTD2);
 *
 * int main() {
 *     while(1) {
 *         printf("Measured : %.1f\n", sr04.read());
 *         wait(0.2);
 *     }
 * }
 * @endcode
 */
 
class SR04 {
public:

    /** Create a SR04 object, connected to the specified pins
     *
     * @param trigger DigitalOut to the SR04 trigger
     * @param echo InterruptIn to measure the return pulse
     */
    SR04(PinName trigger, PinName echo);
    
    /** A non-blocking function that will return the last measurement
     *
     * @returns floating point representation of distance in cm
     */
    float read();

    /** A short hand way of using the read function */
    operator float();
    
private :
    DigitalOut _trigger;
    InterruptIn _echo;
    Timer _timer;
    Ticker _ticker;
    void _rising (void);
    void _falling (void);
    void _startRange (void);
    float _dist;
};

#endif
