#include "SR04.h"
#include "mbed.h"

// PTD2 is RX - data in
// PTD3 is TX - data out
          // TX -> trigger          echo -> RX
SR04::SR04(PinName trigger, PinName echo) 
    : _trigger(trigger), _echo(echo) {    
        
    // Attach interrupts
    _echo.rise(this, &SR04::_rising);
    _echo.fall(this, &SR04::_falling);
    _ticker.attach(this, &SR04::_startRange, 0.1);     
}
  
void SR04::_startRange() {
    // send a trigger pulse, 10uS long
    _trigger = 1;
    wait (0.00001);
    _trigger = 0;
}

// Clear and start the timer at the begining of the echo pulse
void SR04::_rising(void) {
    _timer.reset();
    _timer.start();
}

// Stop and read the timer at the end of the pulse
void SR04::_falling(void) {
    _timer.stop();
    /*
     * Distance:
     * uS / 58  = centimeters
     * uS / 148 = inches
     * range = high level time * velocity (340M/S) / 2
     */
    _dist = _timer.read_us()/58.0; // distance in centimeters
}

float SR04::read(void) {
    // spin until there is a good value
    return (_dist);
}

SR04::operator float() {
    return read();
}
