#include "button.h"

#include "LCD_DISCO_F429ZI.h"

#define FRAME_COLOR LCD_COLOR_GREEN
#define ID_COLOR LCD_COLOR_WHITE
#define ID_RECT_COLOR LCD_COLOR_RED

extern LCD_DISCO_F429ZI Lcd;

Button::Button(uint8_t id, uint16_t posx, uint16_t posy, uint16_t width, uint16_t height, uint32_t color, uint16_t ColNr){
    Button::id = id;
    Button::posx = posx;
    Button::posy = posy;
    Button::width = width;
    Button::height = height;
    Button::color = color;
    Button::ColNr = ColNr;
    }
    
void Button::DrawButton(uint32_t color){
    Lcd.SetTextColor(FRAME_COLOR);
    Lcd.DrawRect(posx+(80*Button::ColNr), posy, width, height);
    Lcd.SetTextColor(color);
    Lcd.FillRect(posx+(80*Button::ColNr)+1, posy+1, width-2, height-2);
    Lcd.SetBackColor(ID_RECT_COLOR);
    Lcd.SetTextColor(ID_COLOR);
    //id = '0' + id;
    Lcd.DisplayStringAt(posx+(80*Button::ColNr), posy, &id, LEFT_MODE);
    }
    
void Button::SetCol(uint16_t ColNr){
    Button::ColNr = ColNr;
    }