#include "Led_Lcd.h"
#include "LCD_DISCO_F429ZI.h"

#define BUTTON0_PR_COLOR LCD_COLOR_RED
#define BUTTON1_PR_COLOR LCD_COLOR_DARKGREEN
#define BUTTON2_PR_COLOR LCD_COLOR_LIGHTRED
#define BUTTON3_PR_COLOR LCD_COLOR_BLACK
#define BUTTON_REL_COLOR LCD_COLOR_BLUE

extern LCD_DISCO_F429ZI Lcd;
extern Button Button4('0', 0, 0, 80, 80, BUTTON_REL_COLOR, 0);
extern Button Button5('1', 0, 80, 80, 80, BUTTON_REL_COLOR, 0);
extern Button Button6('2', 0, 160, 80, 80, BUTTON_REL_COLOR, 0);
extern Button Button7('3', 0, 240, 80, 80, BUTTON_REL_COLOR, 0);

LedLcd::LedLcd(uint16_t ColNr){
    Button4.SetCol(ColNr);
    Button5.SetCol(ColNr);
    Button6.SetCol(ColNr);
    Button7.SetCol(ColNr);
    Button4.DrawButton(BUTTON_REL_COLOR);
    Button5.DrawButton(BUTTON_REL_COLOR);
    Button6.DrawButton(BUTTON_REL_COLOR);
    Button7.DrawButton(BUTTON_REL_COLOR);
    }

void LedLcd::On(uint16_t ucButtonNr){
    Button4.DrawButton(BUTTON_REL_COLOR);
    Button5.DrawButton(BUTTON_REL_COLOR);
    Button6.DrawButton(BUTTON_REL_COLOR);
    Button7.DrawButton(BUTTON_REL_COLOR);
    
    switch(ucButtonNr){
        case 0:
            Button4.DrawButton(BUTTON0_PR_COLOR);
        break;
        case 1:
            Button5.DrawButton(BUTTON1_PR_COLOR);
        break;
        case 2:
            Button6.DrawButton(BUTTON2_PR_COLOR);
        break;
        case 3:
            Button7.DrawButton(BUTTON3_PR_COLOR);
        break;
        default:
        break;
        }
    }
    