#include "Keyboard_Ts.h"
#include "button.h"
#include "LCD_DISCO_F429ZI.h"
#include "TS_DISCO_F429ZI.h"

LCD_DISCO_F429ZI Lcd;
TS_DISCO_F429ZI Ts;

TS_StateTypeDef TS_State;

#define BUTTON_REL_COLOR LCD_COLOR_BLUE
#define BACKGROUND LCD_COLOR_BLACK

extern Button Button0('0', 0, 0, 80, 80, BUTTON_REL_COLOR, 0);
extern Button Button1('1', 0, 80, 80, 80, BUTTON_REL_COLOR, 0);
extern Button Button2('2', 0, 160, 80, 80, BUTTON_REL_COLOR, 0);
extern Button Button3('3', 0, 240, 80, 80, BUTTON_REL_COLOR, 0);

KeyboardTs::KeyboardTs(uint16_t ColNr){
    //Background
    Lcd.SetTextColor(BACKGROUND);
    Lcd.FillRect(0, 0, 240, 320);
    //Buttons   
    SetCol(ColNr); 
    Button0.SetCol(ColNr);
    Button1.SetCol(ColNr);
    Button2.SetCol(ColNr);
    Button3.SetCol(ColNr);
    Button0.DrawButton(BUTTON_REL_COLOR);
    Button1.DrawButton(BUTTON_REL_COLOR);
    Button2.DrawButton(BUTTON_REL_COLOR);
    Button3.DrawButton(BUTTON_REL_COLOR);
    }
    
enum KeyboardState KeyboardTs::eRead(void){
    Ts.GetState(&TS_State);
    
    if(TS_State.TouchDetected && TS_State.X >= (1+KeyboardTs::ColNr*80) && TS_State.X < (80+KeyboardTs::ColNr*80) && TS_State.Y >= 1 && TS_State.Y < 80){
        return BUTTON_0;
        }
    else if(TS_State.TouchDetected && TS_State.X >= (1+KeyboardTs::ColNr*80) && TS_State.X < (80+KeyboardTs::ColNr*80) && TS_State.Y >= 81 && TS_State.Y < 160){
        return BUTTON_1;
      } 
     else if(TS_State.TouchDetected && TS_State.X >= (1+KeyboardTs::ColNr*80) && TS_State.X < (80+KeyboardTs::ColNr*80) && TS_State.Y >= 161 && TS_State.Y < 240){
        return BUTTON_2;
      }
     else if(TS_State.TouchDetected && TS_State.X >= (1+KeyboardTs::ColNr*80) && TS_State.X < (80+KeyboardTs::ColNr*80) && TS_State.Y >= 241 && TS_State.Y < 320){
        return BUTTON_3;
      }
    else{
        return RELEASED;
        }
    }
    
void KeyboardTs::SetCol(uint16_t ColNr){
    KeyboardTs::ColNr = ColNr;
}