/*********************************************************
*buggy_functions.h                                       *
*Author: Elijah Orr & Dan Argust                         *
*                                                        *
*A library of functions that can be used to control the  *
*RenBuggy.                                               *
*********************************************************/

/* include guards are used to prevent problems caused by 
multiple definitions */
#ifndef BUGGY_FUNCTIONS_H
#define BUGGY_FUNCTIONS_H

/* mbed.h must be included in this file also */
#include "mbed.h"

/* #define LeftMotorPin p5 tells the preprocessor to replace
any mention of LeftMotorPin with p5 etc. */
#define LeftMotorPin p5
#define RightMotorPin p6

/* these are function prototypes that declare all the functions
in the library.*/
extern void forward(float); //Move the buggy forward for (float) seconds
extern void left(float); //Turn left for (float) seconds
extern void right(float); //Turn right for (float) seconds
extern void hold(float); //Hold the buggy in an idle state for (float) seconds
extern void stop(); //Stop all motors

extern void readButton(float); //Similar to hold, but scans for button presses while waiting
extern int rollDice(); //Randomly generate a number a display it on the seven segment display

/* stop() and rollDice() do not need to be giving a float
to be run unlike the other functions which use a (float)
to know how long they should run for */

#endif // BUGGY_FUNCTIONS_H