#include "mbed.h"

// Scans through the D/A converter values, and copies a set of A/D converter values to file on USB local filesystem.
// Connect pin 18 to pin 17.

AnalogOut aout(p18);
AnalogIn ain(p17);
LocalFileSystem local("local");               // Create the local filesystem under the name "local"

const int N = 100;
int i;
int n;
unsigned short x[N];
//short trim = 3; // ADC trim; appears this is added to the ADC readings (i.e, -8 gives results in too low readings, 0 gives about correct readings, +3 gives really correct readings for my system, and +7 gives too high readings.) 

int main() {
    FILE *fp = fopen("/local/out.txt", "w");  // Open "out.txt" on the local file system for writing
    //LPC_ADC->ADTRM&=~0x00F0;  //zero the ADC trim bits
    //LPC_ADC->ADTRM|=(trim<<4) & 0x00F0;   //set the trim
    //LPC_SC->PCONP &= ~(1<<30);  //optionally power down various parts of the lpc1768
    //LPC_SC->PCONP &= ~(1<<10);    
    //LPC_SC->PCONP &= ~(1<<27);    
    for (i=0;i<1024;i++) {
        aout.write_u16(i<<6);
        wait(0.001);
        for (n=0;n<N;n++) {
            x[n]=ain.read_u16();
        }
        fwrite(x,sizeof(x[0]),sizeof(x)/sizeof(x[0]),fp);
    }
    fclose(fp);
}
