% matlab code to plot results (multiple files):

fs={'OUT.TXT'
    'OUTPSU.TXT'
    'OUTUSBtiedgnd.TXT'
    'OUTPSUtiedgnd.TXT'
    'OUTUSBlongwait.TXT'
    'OUTPSUlongwait.TXT'
    'OUTUSBtiedgndlongwait.TXT'
    'OUTPSUtiedgndlongwait.TXT'};
clear d
for i=1:numel(fs),
  fh=fopen(fs{i},'r');
  d(:,:,i)=fix(fread(fh,[100,1024],'uint16')/16);
  fclose(fh);
end

%all the measurements as dots:
figure
m=0:1023;
m=repmat(m*4,[size(d,1),1,size(d,3)]);
c='rgbmrgbm';
for i=5:8,
  plot(m(:,:,i),d(:,:,i),[c(i) '.']); hold on
end
axis tight

%statistics:
d=reshape(d,100*1024,8);
m=reshape(m,100*1024,8);
m=m+median(d(:)-m(:));
top=(d>4096-6 & m<4096-100);
bottom=(d<6 & m>100);
above=(d>m+100 & d<=4096-6);
below=(d<m-100 & d>=6);
bar(0:7,[sum(bottom); sum(below); sum(above); sum(top)]','stacked')

figure
plot(m,d,'k.'); hold on
plot(m(top),d(top),'r.'); hold on
plot(m(above),d(above),'y.'); hold on
plot(m(below),d(below),'c.'); hold on
plot(m(bottom),d(bottom),'b.'); hold on
axis tight
