// Scans through the D/A converter values, and copies a set of A/D converter values to file on USB local filesystem.
// Connect pin 18 to pin 17.

#include "mbed.h"

AnalogOut aout(p18);
LocalFileSystem local("local");               // Create the local filesystem under the name "local"

const int N = 100;  //number of samples per D/A value
int i;
int n;
unsigned short x[N];
short trim = 3; // ADC trim; appears this is added to the ADC readings in two's complement (i.e, -8 gives results in too low readings, 0 gives about correct readings, +3 gives really correct readings for my system, and +7 gives too high readings.) 

// /4 /26 -> mbed
// /8 /3 -> nice
// /1 /8 -> 12MHz (max) (ugly)
// /1 /12 (i.e., 11 in reg.) -> nice
 
int main() {
    // A/D power on, set A/D clk divider /4
    LPC_SC->PCONP |= (1 << 12);        // power on, PCADC bit
    LPC_SC->PCLKSEL0 &= ~(0x1 << 24);  // PCLK_ADC=0,1,2,3 -> CCLK /4,/1,/2,/8

    // software-controlled ADC settings
    LPC_ADC->ADCR = (0 << 0) // SEL: 0 = no channels selected yet
              | (11 << 8)    // CLKDIV: PCLK_ADC0 is divided by this number+1 (8 bits)
              | (0 << 16)    // BURST: 0 = software control 
              | (1 << 21)    // PDN: 1 = operational
              | (0 << 24);   // START: 0 = no start

    //p15 = LPC1768 pin  9 = P0.23 = AD0.0 = PINSEL1 bit 15&14 01  
    //p16 = LPC1768 pin  8 = P0.24 = AD0.1 = PINSEL1 bit 17&16 01
    //p17 = LPC1768 pin  7 = P0.25 = AD0.2 = PINSEL1 bit 19&18 01
    //p19 = LPC1768 pin 21 = P1.30 = AD0.4 = PINSEL3 bit 29&28 11 
    //p20 = LPC1768 pin 20 = P1.31 = AD0.5 = PINSEL3 bit 31&30 11
    //Same bits in PINMODEi, set these to 10 to disconnect pull up/pull down resistors
    LPC_PINCON->PINSEL1  &= ~((unsigned int)0x3 << 18);
    LPC_PINCON->PINSEL1  |=   (unsigned int)0x1 << 18;
    LPC_PINCON->PINMODE1 &= ~((unsigned int)0x3 << 18);
    LPC_PINCON->PINMODE1 |=   (unsigned int)0x2 << 18;   // neither pull up nor pull down
    LPC_ADC->ADCR &= ~0xFF;
    LPC_ADC->ADCR |= 1 << 2;   // ADC0[2]
/*  LPC_PINCON->PINSEL3  &= ~((unsigned int)0x3 << 28);
    LPC_PINCON->PINSEL3  |=   (unsigned int)0x3 << 28;
    LPC_PINCON->PINMODE3 &= ~((unsigned int)0x3 << 28);
    LPC_PINCON->PINMODE3 |=   (unsigned int)0x2 << 28;   // neither pull up nor pull down
    LPC_ADC->ADCR &= ~0xFF;
    LPC_ADC->ADCR |= 1 << 4;  // ADC0[4]
*/
    LPC_ADC->ADTRM&=~0x00F0;
    LPC_ADC->ADTRM|=(trim<<4) & 0x00F0;   //set the trim

    FILE *fp = fopen("/local/out.txt", "w");  // Open "out.txt" on the local file system for writing
    for (i=0;i<1024;i++) {
        aout.write_u16(i<<6);
        wait(0.000100);
        for (n=0;n<N;n++) {
            // Select channel and start conversion
            LPC_ADC->ADCR |= 1 << 24;
    
            // Repeatedly get the sample data until DONE or OVERRUN bit
            unsigned int data;
            do {
               data = LPC_ADC->ADGDR;
            } while ((data & ((unsigned int)3 << 30)) == 0);
            x[n]=data;
        }
        // Stop conversions    
        LPC_ADC->ADCR &= ~(1 << 24);

        fwrite(x,sizeof(x[0]),sizeof(x)/sizeof(x[0]),fp);
    }
    fclose(fp);
}

