/*
 * Demonstrates sending a buffer repeatedly to the DAC using DMA.
 * Connect an oscilloscope to Mbed pin 18.
 */

#include "mbed.h"
#include "DMAFuncGen.h"

AnalogIn ain(p17);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

MODDMA dma;
DMAFuncGen fg(dma, MODDMA::Channel_0);

int main() {
    wait(0.5);
   
    // Create waveform.
    fg.buffer_size=400;
    fg.buffer = new uint32_t[fg.buffer_size];
    const float PI = 3.1415927;
    for (int i=0; i<fg.buffer_size; i++) {
        int x = (511*sin(2*PI*i/fg.buffer_size)) +512;
        fg.set(i,x << 6);
    }
    
    fg.Connect();
    fg.Setup();
    fg.SetFrequency(0.5);
    printf("Frequency: %f\r\n",fg.Frequency());
    fg.Start();
    
    // Simple oscilloscope, using the LEDs -
    // Connect pin 18 (DAC) to p17 (ADC) for it to work.
    float z;
    while (1){
        z=ain.read();
        led1 = (z > 0.2) ? 1 : 0;
        led2 = (z > 0.4) ? 1 : 0;
        led3 = (z > 0.6) ? 1 : 0;
        led4 = (z > 0.8) ? 1 : 0;
    }
}
