#include "mbed.h"
#include "MODSERIAL.h"
#include "BiQuad.h"
#include "BiQuad4.h"
#include "FilterDesign.h"
#include "FilterDesign2.h"
#include "HIDScope.h"
MODSERIAL pc(USBTX, USBRX); //makes sure the computer is hooked up
Ticker sample;

AnalogIn emg1_raw(A0);
AnalogIn emg2_raw(A1);
DigitalOut ledr(LED_RED);
DigitalOut ledg(LED_GREEN);
enum states {CALIBRATING,MOVE};
states currentState = CALIBRATING;

//global variables
double emg1_cal = 0.00000; //measured value of the first emg
double emg2_cal = 0.00000; //measured value of the second emg
double EMG_calibrated_max_1 = 0.00000; //final calibration value of EMG1
double EMG_calibrated_max_2 = 0.00000; //final calibration value of EMG2
const float threshold_EMG = 0.1;         // threshold op 25 procent van maximale waarde 

void ReadEMG()
{
    emg1_cal = FilterDesign(emg1_raw.read());
    emg2_cal = FilterDesign2(emg2_raw.read());
}

void EMG_calibration()
{
    for (int i = 0; i <= 10; i++) //10 measuring points
        {      
        if (emg1_cal > EMG_calibrated_max_1){
            EMG_calibrated_max_1 = emg1_cal;}
            
        if (emg2_cal > EMG_calibrated_max_2){
            EMG_calibrated_max_2 = emg2_cal;}
            
        pc.printf("EMG1_max = %f, EMG2_max = %f \r\nEMG1_filtered = %f \r\nEMG2_filtered = %f \r\n",EMG_calibrated_max_1,EMG_calibrated_max_2, emg1_cal, emg2_cal);
        wait(0.5f);
        }
}
        
int main(){
    pc.baud(115200);
    // Attach the 'ReadEMG' function to the timer 'sample'. Frequency is 50 Hz.
    sample.attach(&ReadEMG, 0.02f);
    ledr = 1;
    ledg = 1;
    
    
    while (true) {
        switch(currentState){
            case CALIBRATING:
            ledr = 0;
            ledg = 1;
            EMG_calibration();
            pc.printf("Final: EMG1 = %f, EMG2 = %f \r\n",EMG_calibrated_max_1,EMG_calibrated_max_2);
            currentState = MOVE;
            break;
            
            case MOVE:
            ledr = 1;
            ledg = 1;
            if (emg2_cal > (threshold_EMG*EMG_calibrated_max_2)){
                ledr = 0;
                }
            /*
            if (emg1_cal >= (threshold_EMG*EMG_calibrated_max_1) && emg2_cal >= (threshold_EMG*EMG_calibrated_max_2)){
                ledg = 0;
                ledr = 0;
                }
            else if (emg2_cal >= (threshold_EMG*EMG_calibrated_max_2) && emg1_cal < (threshold_EMG*EMG_calibrated_max_1)){
                ledr = 0;
                ledg = 1;
                }
            else if (emg1_cal >= (threshold_EMG*EMG_calibrated_max_1) && emg2_cal < (threshold_EMG*EMG_calibrated_max_2)){
                ledg = 0;
                ledr = 1;
                }
            else {
                ledr = 1;
                ledg = 1;
                }   
            */
            break;
            }
    }
}