#include "mbed.h"
#include "HIDScope.h"
#include "BiQuad.h"
#include "BiQuad4.h"
#include "FilterDesign.h"
#include "FilterDesign2.h"

// This part of the code is used for filtering the two EMG signals and determining if the robot has to move.

//Define objects
AnalogIn    emg1_raw( A0 );
AnalogIn    emg2_raw( A1 );
DigitalOut  ledr(LED_RED);
DigitalOut  ledg(LED_GREEN);

Ticker      sample_EMGtoHIDscope;   //Used to send to hidscope
HIDScope    scope(4);       //Number of channels which needs to be send to the HIDScope
   
int need_to_move_1;          // Does the robot needs to move in the first direction?
int need_to_move_2;          // Does the robot needs to move in the second direction?
double EMG_calibrated_max_1 = 2.00000;  // Maximum value of the first EMG signal found in the calibration state.
double EMG_calibrated_max_2 = 2.00000;  // Maximum value of the second EMG signal found in the calibration state.

float threshold_EMG = 0.25;         // Threshold on 25 percent of the maximum EMG

double emg1_filtered = 0.00;
double emg2_filtered = 0.00;


// Sample: samples the EMG and sends it to HIDScope
void sample()
{
    emg1_filtered = FilterDesign(emg1_raw.read());
    emg2_filtered = FilterDesign2(emg2_raw.read());
    
    scope.set(0, emg1_raw.read());      // Raw EMG 1 send to scope 0
    scope.set(1, emg1_filtered);        // Filtered EMG 1 send to scope 1
    scope.set(2, emg2_raw.read());      // Raw EMG 2 send to scope 2
    scope.set(3, emg2_filtered);        // Filtered EMG 2 send to scope 3
    scope.send();                       // Send the data to the computer
}

int main()
{   
    // Attach the 'sample' function to the timer 'sample_timer'. Frequency is 50 Hz.
    sample_EMGtoHIDscope.attach(&sample, 0.02f);
    
    while(1) {
        if (emg1_filtered >= (threshold_EMG*EMG_calibrated_max_1)){
            need_to_move_1 = 1; // The robot does have to move
            ledr = 1;           // Red LED off
            ledg = 0;           // Green LED on
            }
        else {
            need_to_move_1 = 0; // If the robot does not have to move
            ledr = 0;           // Red LED on 
            ledg = 1;           // Green LED off
            }

        if(emg2_filtered >= threshold*EMG_calibrated_max_2){
            need_to_move_2 = 1;
            ledr = 0;
            ledg = 1;
            }
        else {
            need_to_move_2 = 0;
            ledr = 1;
            ledg = 0;
            }
        }
}