#include "mbed.h"
#include "FastPWM.h"
#include "MODSERIAL.h"
#include "HIDScope.h"


/*
Hallo!

Het is tijd om de demo mode met behulp van potmeters te laten draaien :)
Zorg ervoor dat de potmeters met de draadjes aan de juiste poorten op de MBed zijn gekoppeld.
Het zijn de twee helemaal links onderin.

Veel succes ermee en wees voorzichtig!
*/

AnalogIn  potmeter1(PTC10);
AnalogIn  potmeter2(PTC11);
MODSERIAL  pc(USBTX, USBRX);

//D4 is a digital input for the microcontroller, so should be an digitalOut
//from the K64F. It will tell the motor shield to let Motor1 turn clockwise
//or counter clockwise (CW of CCW). D7 for motor 2
DigitalOut directionM1(D4);
DigitalOut directionM2(D7);
//D5 is a PWM input for the motor controller and determines the PWM signal 
//that the motor controller gives to Motor 1. Higher PWM, higher average voltage.
//D6 for motor 2
FastPWM motor1_pwm(D5);
FastPWM motor2_pwm(D6);

// Voor het laten zien van de data op de pc.
HIDScope scope(2);              // Aantal kanalen wat doorgegeven wordt aan de hidscope
Ticker AInTicker;
float U1;
float U2;
float potwaarde1;
float potwaarde2;

void ReadAnalogIn()
{
    scope.set(0,U1);    // Zet de potwaarde in de eerste plot bij de HID scope. Deze wordt automatisch tegen de tijd geplot
    scope.set(1,U2);
    scope.send();               // Zendt de waardes naar de pc 
    }

int main(void)
{
    motor1_pwm.period_ms(60); // period is 60 ms
    AInTicker.attach(&ReadAnalogIn,0.01f);  //Elke 0.01 sec. Lees de analoge waarde
 
    while(true){
        potwaarde1 = potmeter1.read();  // Lees de potwaardes uit. Tussen 0 en 1
        potwaarde2 = potmeter2.read();
                      
        U1 = potwaarde1 -0.5;   // Scale van -0.5 tot 0.5 ipv. 0 tot 1
        U2 = potwaarde2 -0.5;
        
        // Gebruik de absolute waarde van de scaled U waardes als input voor de motor. 
        // Negatieve waardes kunnen niet naar de motor gestuurd worden.
        motor1_pwm.write(fabs(U1)); 
        motor2_pwm.write(fabs(U2));
        
        directionM1 = U1 > 0.0f; //either true or false
        directionM2 = U2 > 0.0f;
        
        wait(0.002f);
        }
}