#include "mbed.h"
#include "MODSERIAL.h"
MODSERIAL pc(USBTX, USBRX);\

// Make a BlinkLEd function using Ticker
//Wait for a character to arrive pc.getc() in the main loop,
//if character == ‘r’ blink red LED
//if character == ‘b’ blink blue LED
//if character == ‘g’ blink green LED

Ticker blink;                   //Create the ticker       

char currentState;              //Make character currentState

DigitalOut ledr(LED_RED);       //Define DigitalOuts for every colour
DigitalOut ledb(LED_BLUE);
DigitalOut ledg(LED_GREEN);



void BlinkLed(void)             //Define the function which makes the led blink
{
    switch (currentState)       //Make a switch which takes the character from the keyboard
    {   
        case 'r':               //If the input character is r..
            ledr = !ledr;       //let the red light blink..
            ledb=1;             //and turn off the rest
            ledg=1;
            break;
            
        case 'b':             //If the input character is b
            ledb = !ledb;
            ledr=1;
            ledg=1;
            break;
            
        case 'g':             //If the input character is g
           ledg= !ledg;    
           ledb=1;
           ledr=1;
            break; 
            
        default:
            break;
    }           // End of switch
} 
        
int main()
{
//Start with the LED switched off
ledr = 1;
ledb = 1;
ledg = 1;

    blink.attach(BlinkLed,1);       //Gaat elke seconde checken
    pc.baud(115200);                //Instelling voor pc
       
    while (true) {
       currentState = pc.getc();                 
    }
}