#ifndef BIQUAD4_BIQUAD4_H
#define BIQUAD4_BIQUAD4_H

#include <vector>
#include <complex>

/** BiQuad class implements a single filter
 *
 * Filters that - in the z domain - are the ratio of two fourth order functions. The general form is:
 *
 *        b0 + b1 z^-1 + b2 z^-2 + b3 z^-3 + b4 z^-4
 * H(z) = ------------------------------------------
 *        a0 + a1 z^-1 + a2 z^-2 + a3 z^-3 + a4 z^-4
 * Which is often normalized by dividing all coefficients by a0.
 */
class BiQuad4 {

private:

    double B[5];
    double A[4];
    double wz[4];
    
    bool resetStateOnGainChange;

  /**
     * Sets the gain parameters
     */
    void set( double b0, double b1, double b2, double b3, double b4, double a1, double a2, double a3, double a4 );

public:

    /**
     * Initialize a unity TF biquad
     * @return BiQuad instance
     */
    BiQuad4( );

    // Initialize a normalized biquad filter
     
    BiQuad4( double b0, double b1, double b2, double b3, double b4, double a1, double a2, double a3, double a4 );

    /**
     * Execute one digital timestep and return the result...
     * @param x input of the filer
     * @return output of the filter
     */
    double step( double x );

    void setResetStateOnGainChange( bool v );
};

#endif //BIQUAD_BIQUAD_H
