#include "mbed.h"
/* Code for mbed NXP LPC1768 */

/* Code goal: drive two LEDs using PWM */

/* 
   According to mbed-005.1 schematic pins:
   1.18 connected to LED1 and 1.20 connected to LED2
   are capable to deploy PWM functionality.
*/

// Configure pin 1.18 (LED 1) to deploy PWM functionality
PwmOut rising_pwm(LED1);
// Configure pin 1.19 (LED 2) to deploy PWM functionality
PwmOut dimming_pwm(LED2);

int main() 
{  
    // initial values for pwm
    rising_pwm = 0;
    dimming_pwm = 1.0;
    
    while(1)
    {
        rising_pwm = rising_pwm + 0.01;
        dimming_pwm = dimming_pwm - 0.01;
        
        // wait time to observe pwm modulation
        wait (0.2);
        
        // re-initialize pwm values when reached top and bottom values
        if( rising_pwm >= 1.0 )
        {
            rising_pwm = 0.0;
        }
        
        if( dimming_pwm <= 0 )
        {
            dimming_pwm = 1.0;
        }
    }
}
