#include "menu.h"

C12832_LCD lcd;
BusIn joystick_sel(p12, p14, p15);
/*
DigitalIn sw_right(p16);
DigitalIn sw_up(p15);
DigitalIn sw_enter(p14);
DigitalIn sw_left(p13);
DigitalIn sw_down(p12);
*/
DigitalOut myled_2(LED2);

unsigned char menu_selection = 1;


const char menu_000[] = "      -Main Screen-      ";
const char menu_001[] = " Option 1 ";
const char menu_002[] = " Option 2 ";
const char menu_003[] = " Option 3 ";
const char menu_004[] = " Option 4 ";
const char menu_005[] = " Option 5 ";
const char menu_006[] = " Option 6 ";
const char menu_007[] = " Option 7 ";
const char menu_008[] = " Option 8 ";
const char menu_009[] = " START ";


const char menu_100[] = "    [Sub Menu]    ";
const char menu_101[] = " SubOption 1 ";
const char menu_102[] = " SubOption 2 ";
const char menu_103[] = " SubOption 3 ";
const char menu_104[] = " SubOption 4 ";
const char menu_105[] = " SubOption 5 ";
const char menu_106[] = " SubOption 6 ";

menuEntry menu[] = {
    {menu_000, 10, 0, 0, 0, 0},
    {menu_001, 10, 1, 2, 11, 0},
    {menu_002, 10, 1, 3, 2, 0},
    {menu_003, 10, 2, 4, 3, 0},
    {menu_004, 10, 3, 5, 4, 0},
    {menu_005, 10, 4, 6, 5, 0},
    {menu_006, 10, 5, 7, 6, 0},
    {menu_007, 10, 6, 8, 7, 0},
    {menu_008, 10, 7, 9, 8, 0},
    {menu_009, 10, 8, 9, 9, start},
    
    {menu_100, 7, 0, 0, 0, 0},
    {menu_101, 7, 11, 12, 11, 0},
    {menu_102, 7, 11, 13, 12, 0},
    {menu_103, 7, 12, 14, 13, 0},
    {menu_104, 7, 13, 15, 14, 0},
    {menu_105, 7, 14, 16, 15, 0},
    {menu_106, 7, 15, 16, 1, 0}
};

void show_menu(void)    
{
    unsigned int line_cnt = 0;
    unsigned char from = 0;
    unsigned char till = 0;
    unsigned char temp = 0;
    
    while( till <= menu_selection ) 
    {
        till += menu[till].menupoints;
    }
    
    from = till - menu[menu_selection].menupoints;
    till--;
    
    temp = from;
    
    if( (menu_selection >= (from+2)) && (menu_selection <= (till-1)))
    {
        from = menu_selection - 2;   
        till = from + 3;
        
        for(from = from; from <= till; from++)
        {
            lcd.locate(7, 8*line_cnt);
            lcd.printf("%s", menu[from].text);
            line_cnt++;
        }
        lcd.locate(0, 8*2);
        lcd.printf(">"); 
    }else{
        // selection is within the top - 2 last 2 spaces
        if(menu_selection <= (from+2))
        {
            till = from + 3;
            for(from = from; from <= till; from++)
            {
                lcd.locate(7, 8*line_cnt);
                lcd.printf("%s", menu[from].text);
                line_cnt++;
            }
            lcd.locate(0, 8*(menu_selection-temp));
            lcd.printf(">");            
        }
        if(menu_selection == till)
        {
            from = till - 3;
            
            for(from = from; from <= till; from++)
            {
                lcd.locate(7, 8*line_cnt);
                lcd.printf("%s", menu[from].text);
                line_cnt++;
            }
            lcd.locate(0, 8*3);
            lcd.printf(">");             
        }
    } 
            lcd.locate(0,0);
        lcd.printf("%d %d", menu_selection, line_cnt);  
}

void browse_menu(void)
{
    do{

        show_menu();
        switch(joystick_sel){
            case 0x01:
                    menu_selection = menu[menu_selection].down;
                break;
            case 0x02:
                    menu_selection = menu[menu_selection].enter;
                    if(menu[menu_selection].fp != 0)
                    {
                        menu[menu_selection].fp();
                        
                        menu_selection = menu[menu_selection].enter;
                    }
                break;  
            case 0x04:
                    menu_selection = menu[menu_selection].up;
                break;     
        }

 //       while(1)
   //     {
            myled_2 = 1;
    
            wait(0.25);
            myled_2 = 0;
    
            wait(0.25);
     //   }
 /*       if(sw_up){
            menu_selection = menu[menu_selection].up;
        }
        if(sw_down){
            menu_selection = menu[menu_selection].down;
        }
            if(sw_left){
                menu_selection = menu[menu_selection].up;
            }        
        if(sw_enter){
            menu_selection = menu[menu_selection].enter;
            if(menu[menu_selection].fp != 0)
            {
                menu[menu_selection].fp();
                
                menu_selection = menu[menu_selection].enter;
            }
            wait(0.05);
        }      
*/
    }while(1);   
}


void start(void)
{
    lcd.cls();
    lcd.locate(0, 0); lcd.printf("Start option selected");  
    
    while(1)
    {
    }
}