/*
 * Copyright (C) 2015 Wiznet, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <stdio.h>
#include <stdlib.h>

#include "Servo.h"

#include "mbed.h"
#include "WizFi250Interface.h"

#define ECHO_SERVER_PORT    7777

#define SECURE WizFi250::SEC_WPA2_MIXED
#define SSID "WizFi250_AP_Test"
#define PASS "1234567890"

#if defined(TARGET_WIZwiki_W7500)
    WizFi250Interface wizfi250(D1,D0,D7,D8,PA_12,NC,115200);
    Serial pc(USBTX, USBRX);
#endif

DigitalOut red(LED1);
DigitalOut green(LED2);

void TCPServer();
void UDPServer();

char speed_str[6];
char direction_str[10];
volatile float speed_values;
volatile float direction_values;
volatile int speed_temp=0;



Servo myservo(D6); //서보모터 
PwmOut mypwm(D5); //브러쉬드DC모터

int main()
{
    pc.baud(115200);
    
    speed_values=0.0650; //중립value 0.0650
    direction_values=0.5; //중립value 0.5
    
    red=1; //led off
    green=1; //led off
 
    printf("WizFi250 Hello World demo. \r\n");
    wizfi250.init();
    wizfi250.setAddress("192.168.101.10","255.255.255.0","192.168.101.1");
    if ( wizfi250.connect(SECURE, SSID, PASS, WizFi250::WM_AP))      return -1;
    printf("IP Address is %s\r\n", wizfi250.getIPAddress());
    
    mypwm=speed_values;
    myservo=direction_values;
    wait(2);
    
    //TCPServer();
    UDPServer();
    
    wizfi250.disconnect();

}

void TCPServer(){
    char buffer[1024];
    int n = 0;

    
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();

    printf("\nWait for new connection...\r\n");
    green=0;
    wait(0.5f);
    green=1;
    wait(0.5f);
    green=0;
    wait(0.5f);
    green=1;
    
    TCPSocketConnection client;
    server.accept(client);
    client.set_blocking(false, 1500);

    printf("Connection from: %s\r\n", client.get_address());
    
    
    while (true)
    {
        if( client.is_connected() == false )
        {
            //client.close();
            //printf("Client Close\r\n");
            server.accept(client);
            client.set_blocking(false, 1500);
            //break;
        }

        n = client.receive(buffer, sizeof(buffer));
        if( n > 0 )
        {
            buffer[n] = '\0';
            /*
            if(buffer[0] == 'H'){
                myled=0;
                printf("\n[LED On]\r\n");
            }else if(buffer[0] == 'L'){
                myled=1;
                printf("\n[LED Off]\r\n");
            }else{
                printf("length : %d\r\n", n);
                client.send_all(buffer, n);  
            }*/
            
            if(buffer[0] == 'D'){
                direction_str[0]=buffer[1];
                direction_str[1]=buffer[2];
                direction_values = atoi(direction_str);
                
                direction_values = direction_values * 0.01;
                
                if(direction_values > 0.90)
                    direction_values = 0.9;
                else if(direction_values < 0.10)
                    direction_values = 0.1;
                printf("Direction value : %f\r\n", direction_values);    
                
                speed_str[0]=buffer[3];
                speed_str[1]=buffer[4];
                speed_str[2]=buffer[5];
                speed_str[3]=buffer[6];
                
                speed_values = atoi(speed_str);
                speed_temp=speed_values;
                speed_values = speed_values * 0.00001;
                printf("Speed value : %f, %d\r\n", speed_values, speed_temp);
                
                mypwm = (double) speed_values;
                myservo = (double) direction_values;  
            }else{
                //printf("not if\r\n");
                printf("%s\r\n", buffer);
            }
            //printf("length : %d\r\n", n);
            //client.send_all(buffer, n);  
            
        }        
    }
}

void UDPServer(){
    UDPSocket server;
    printf("Socket create\r\n");
    server.set_blocking(false);
    printf("Blocking\r\n");
    server.bind(ECHO_SERVER_PORT);
    printf("Bind\r\n");

    Endpoint client;
    printf("Client create\r\n");
    green=0;
    wait(0.3f);
    green=1;
    wait(0.3f);
    green=0;
    wait(0.3f);
    green=1;
    
    //char buffer[256];
    char buffer[7] = {0};
    volatile int n=0;
    
    while(true){
        //printf("Receive\r\n");
        n = server.receiveFrom(client, buffer, sizeof(buffer));
        
        //printf("Receive\r\n");
        
        if(n > 0){            
            if(buffer[0] == 'D'){
                green=0; //On
                
                direction_str[0]=buffer[1];
                direction_str[1]=buffer[2];
                direction_values = atoi(direction_str);
                
                direction_values = direction_values * 0.01;
                
                /*
                if(direction_values > 0.90)
                    direction_values = 0.9;
                else if(direction_values < 0.10)
                    direction_values = 0.1;
                */
                printf("Direction value : %f\r\n", direction_values);    
                
                
                printf("[%c%c%c]", buffer[0], buffer[1], buffer[2]);
                
                speed_str[0]=buffer[3];
                speed_str[1]=buffer[4];
                speed_str[2]=buffer[5];
                speed_str[3]=buffer[6];
                
                speed_values = atoi(speed_str);
                speed_temp=speed_values;
                speed_values = speed_values * 0.00001;
                printf("Speed value : %f, %d\r\n", speed_values, speed_temp);
                
                mypwm = (double) speed_values;
                myservo = (double) direction_values;  
            }else{
                red=0;
                if(buffer[1]=='D'){
                    green=0;
                    green=1;
                    green=0;
                    green=1;
                    direction_str[0]=buffer[2];
                    direction_str[1]=buffer[3];
                    direction_values = atoi(direction_str);
                    
                    direction_values = direction_values * 0.01;
                    
                    if(direction_values > 0.90)
                        direction_values = 0.9;
                    else if(direction_values < 0.10)
                        direction_values = 0.1;
                    printf("Direction value : %f\r\n", direction_values);    
                    
                    
                    printf("[%c%c%c]", buffer[0], buffer[1], buffer[2]);
                    
                    speed_str[0]=buffer[4];
                    speed_str[1]=buffer[5];
                    speed_str[2]=buffer[6];
                    speed_str[3]=0;
                    
                    speed_values = atoi(speed_str);
                    speed_temp=speed_values;
                    speed_values = speed_values * 0.00001;
                    printf("Speed value : %f, %d\r\n", speed_values, speed_temp);
                    
                    mypwm = (double) speed_values;
                    myservo = (double) direction_values;  
                }
                printf("%s\r\n", buffer);
                memset(buffer, 0, sizeof(buffer));
                
            }
            green=1;
            red=1;
            memset(buffer, 0, sizeof(buffer));
        }
    }
}
