#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "MiniTLS-GPL/cpp/MiniTLS.h"
 
MiniTLS miniTLS;
EthernetInterface eth;
HTTPClient http;
char str[512];

const uint8_t pub_key[] = {
/*0x30,0x82,0x01,0x22,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,
0x01,0x05,0x00,0x03,0x82,0x01,0x0F,0x00,*/0x30,0x82,0x01,0x0A,0x02,0x82,0x01,0x01,
0x00,0xEC,0x4F,0x55,0x0A,0xD8,0xB1,0x6D,0xA1,0xB1,0x9F,0x1C,0xD8,0x93,0xE9,0x64,
0x64,0x77,0x14,0x28,0x53,0x70,0xD6,0x4F,0xCF,0x99,0x3A,0x38,0x36,0xF9,0x7B,0x77,
0xAB,0x0C,0x1D,0xE0,0x5B,0x55,0x93,0x09,0x34,0x31,0x8A,0x98,0xF0,0x98,0xB8,0x29,
0xC2,0xF8,0x1E,0xFF,0xD8,0x8F,0xD5,0x91,0x4C,0xD6,0x32,0xF2,0x67,0x33,0x79,0xF4,
0x4E,0x92,0xD8,0x75,0xD3,0x2F,0xD3,0xB6,0xB5,0x3E,0xB9,0xFB,0x48,0xF9,0xCB,0x04,
0x50,0xC0,0xB0,0x54,0x00,0x85,0xE6,0x35,0x0B,0x0C,0x8C,0x76,0x01,0x86,0x6D,0xA3,
0x3A,0xCD,0xF4,0x67,0xF4,0x2A,0x1D,0x80,0xE6,0xF5,0x43,0xA8,0x05,0x6B,0x2E,0xA8,
0x22,0x21,0xA6,0xA6,0xE0,0x0D,0x96,0x2D,0x10,0x75,0x11,0x57,0xE8,0x23,0xEC,0x8E,
0x1E,0xAD,0x3C,0x26,0xC4,0x57,0x9F,0xE5,0x33,0x3D,0x66,0xF4,0x12,0x6F,0xFF,0x10,
0x87,0xBC,0xCF,0x4D,0xFB,0xF9,0xF1,0xF4,0x8D,0x78,0x1A,0x49,0x7F,0xFB,0x8F,0x3C,
0x6E,0x3E,0x4F,0xDD,0x0A,0xF6,0xC2,0x5F,0xA6,0xDC,0x11,0x89,0xF5,0x10,0x7B,0x00,
0x1A,0x83,0x0B,0xDC,0xF5,0xAE,0x7A,0xB3,0x63,0xD3,0x97,0x71,0xD3,0x27,0x83,0x5D,
0xCA,0x7F,0x44,0x6C,0xDC,0x6F,0x46,0x3D,0x0E,0x6E,0x86,0x31,0xCB,0xF6,0x08,0x18,
0xD6,0x2E,0x45,0xCB,0x9E,0x93,0xCB,0x28,0xA6,0x11,0xE6,0x34,0x07,0x2E,0x06,0x26,
0x34,0xCC,0xD5,0xD2,0xAE,0x6C,0x91,0x1D,0x88,0xF3,0xD2,0xDF,0x7E,0x01,0x4E,0xA4,
0xBF,0x2F,0x7B,0x5B,0xAB,0xB7,0xFA,0xDE,0x7A,0xE9,0x0B,0x6F,0x8D,0x63,0x14,0x70,
0x17,0x02,0x03,0x01,0x00,0x01,
};

const uint8_t certificate[] = {
0x30,0x82,0x04,0xE7,0x30,0x82,0x03,0xCF,0xA0,0x03,0x02,0x01,0x02,0x02,0x10,0x4D,
0x1E,0x6C,0xAF,0x88,0xBD,0xDE,0xD5,0x8A,0x3F,0x99,0x1A,0x76,0x86,0xF0,0xF9,0x30,
0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x0B,0x05,0x00,0x30,0x7E,
0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x1D,0x30,
0x1B,0x06,0x03,0x55,0x04,0x0A,0x13,0x14,0x53,0x79,0x6D,0x61,0x6E,0x74,0x65,0x63,
0x20,0x43,0x6F,0x72,0x70,0x6F,0x72,0x61,0x74,0x69,0x6F,0x6E,0x31,0x1F,0x30,0x1D,
0x06,0x03,0x55,0x04,0x0B,0x13,0x16,0x53,0x79,0x6D,0x61,0x6E,0x74,0x65,0x63,0x20,
0x54,0x72,0x75,0x73,0x74,0x20,0x4E,0x65,0x74,0x77,0x6F,0x72,0x6B,0x31,0x2F,0x30,
0x2D,0x06,0x03,0x55,0x04,0x03,0x13,0x26,0x53,0x79,0x6D,0x61,0x6E,0x74,0x65,0x63,
0x20,0x43,0x6C,0x61,0x73,0x73,0x20,0x33,0x20,0x53,0x65,0x63,0x75,0x72,0x65,0x20,
0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x43,0x41,0x20,0x2D,0x20,0x47,0x34,0x30,0x1E,
0x17,0x0D,0x31,0x34,0x30,0x37,0x31,0x37,0x30,0x30,0x30,0x30,0x30,0x30,0x5A,0x17,
0x0D,0x31,0x35,0x30,0x37,0x32,0x36,0x32,0x33,0x35,0x39,0x35,0x39,0x5A,0x30,0x6E,
0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x47,0x42,0x31,0x17,0x30,
0x15,0x06,0x03,0x55,0x04,0x08,0x0C,0x0E,0x43,0x61,0x6D,0x62,0x72,0x69,0x64,0x67,
0x65,0x73,0x68,0x69,0x72,0x65,0x31,0x12,0x30,0x10,0x06,0x03,0x55,0x04,0x07,0x0C,
0x09,0x43,0x61,0x6D,0x62,0x72,0x69,0x64,0x67,0x65,0x31,0x10,0x30,0x0E,0x06,0x03,
0x55,0x04,0x0A,0x0C,0x07,0x41,0x52,0x4D,0x20,0x4C,0x74,0x64,0x31,0x0D,0x30,0x0B,
0x06,0x03,0x55,0x04,0x0B,0x0C,0x04,0x41,0x44,0x49,0x54,0x31,0x11,0x30,0x0F,0x06,
0x03,0x55,0x04,0x03,0x0C,0x08,0x6D,0x62,0x65,0x64,0x2E,0x6F,0x72,0x67,0x30,0x82,
0x01,0x22,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x01,0x05,
0x00,0x03,0x82,0x01,0x0F,0x00,0x30,0x82,0x01,0x0A,0x02,0x82,0x01,0x01,0x00,0xEC,
0x4F,0x55,0x0A,0xD8,0xB1,0x6D,0xA1,0xB1,0x9F,0x1C,0xD8,0x93,0xE9,0x64,0x64,0x77,
0x14,0x28,0x53,0x70,0xD6,0x4F,0xCF,0x99,0x3A,0x38,0x36,0xF9,0x7B,0x77,0xAB,0x0C,
0x1D,0xE0,0x5B,0x55,0x93,0x09,0x34,0x31,0x8A,0x98,0xF0,0x98,0xB8,0x29,0xC2,0xF8,
0x1E,0xFF,0xD8,0x8F,0xD5,0x91,0x4C,0xD6,0x32,0xF2,0x67,0x33,0x79,0xF4,0x4E,0x92,
0xD8,0x75,0xD3,0x2F,0xD3,0xB6,0xB5,0x3E,0xB9,0xFB,0x48,0xF9,0xCB,0x04,0x50,0xC0,
0xB0,0x54,0x00,0x85,0xE6,0x35,0x0B,0x0C,0x8C,0x76,0x01,0x86,0x6D,0xA3,0x3A,0xCD,
0xF4,0x67,0xF4,0x2A,0x1D,0x80,0xE6,0xF5,0x43,0xA8,0x05,0x6B,0x2E,0xA8,0x22,0x21,
0xA6,0xA6,0xE0,0x0D,0x96,0x2D,0x10,0x75,0x11,0x57,0xE8,0x23,0xEC,0x8E,0x1E,0xAD,
0x3C,0x26,0xC4,0x57,0x9F,0xE5,0x33,0x3D,0x66,0xF4,0x12,0x6F,0xFF,0x10,0x87,0xBC,
0xCF,0x4D,0xFB,0xF9,0xF1,0xF4,0x8D,0x78,0x1A,0x49,0x7F,0xFB,0x8F,0x3C,0x6E,0x3E,
0x4F,0xDD,0x0A,0xF6,0xC2,0x5F,0xA6,0xDC,0x11,0x89,0xF5,0x10,0x7B,0x00,0x1A,0x83,
0x0B,0xDC,0xF5,0xAE,0x7A,0xB3,0x63,0xD3,0x97,0x71,0xD3,0x27,0x83,0x5D,0xCA,0x7F,
0x44,0x6C,0xDC,0x6F,0x46,0x3D,0x0E,0x6E,0x86,0x31,0xCB,0xF6,0x08,0x18,0xD6,0x2E,
0x45,0xCB,0x9E,0x93,0xCB,0x28,0xA6,0x11,0xE6,0x34,0x07,0x2E,0x06,0x26,0x34,0xCC,
0xD5,0xD2,0xAE,0x6C,0x91,0x1D,0x88,0xF3,0xD2,0xDF,0x7E,0x01,0x4E,0xA4,0xBF,0x2F,
0x7B,0x5B,0xAB,0xB7,0xFA,0xDE,0x7A,0xE9,0x0B,0x6F,0x8D,0x63,0x14,0x70,0x17,0x02,
0x03,0x01,0x00,0x01,0xA3,0x82,0x01,0x6F,0x30,0x82,0x01,0x6B,0x30,0x21,0x06,0x03,
0x55,0x1D,0x11,0x04,0x1A,0x30,0x18,0x82,0x0C,0x63,0x64,0x6E,0x2E,0x6D,0x62,0x65,
0x64,0x2E,0x6F,0x72,0x67,0x82,0x08,0x6D,0x62,0x65,0x64,0x2E,0x6F,0x72,0x67,0x30,
0x09,0x06,0x03,0x55,0x1D,0x13,0x04,0x02,0x30,0x00,0x30,0x0E,0x06,0x03,0x55,0x1D,
0x0F,0x01,0x01,0xFF,0x04,0x04,0x03,0x02,0x05,0xA0,0x30,0x1D,0x06,0x03,0x55,0x1D,
0x25,0x04,0x16,0x30,0x14,0x06,0x08,0x2B,0x06,0x01,0x05,0x05,0x07,0x03,0x01,0x06,
0x08,0x2B,0x06,0x01,0x05,0x05,0x07,0x03,0x02,0x30,0x65,0x06,0x03,0x55,0x1D,0x20,
0x04,0x5E,0x30,0x5C,0x30,0x5A,0x06,0x0A,0x60,0x86,0x48,0x01,0x86,0xF8,0x45,0x01,
0x07,0x36,0x30,0x4C,0x30,0x23,0x06,0x08,0x2B,0x06,0x01,0x05,0x05,0x07,0x02,0x01,
0x16,0x17,0x68,0x74,0x74,0x70,0x73,0x3A,0x2F,0x2F,0x64,0x2E,0x73,0x79,0x6D,0x63,
0x62,0x2E,0x63,0x6F,0x6D,0x2F,0x63,0x70,0x73,0x30,0x25,0x06,0x08,0x2B,0x06,0x01,
0x05,0x05,0x07,0x02,0x02,0x30,0x19,0x1A,0x17,0x68,0x74,0x74,0x70,0x73,0x3A,0x2F,
0x2F,0x64,0x2E,0x73,0x79,0x6D,0x63,0x62,0x2E,0x63,0x6F,0x6D,0x2F,0x72,0x70,0x61,
0x30,0x1F,0x06,0x03,0x55,0x1D,0x23,0x04,0x18,0x30,0x16,0x80,0x14,0x5F,0x60,0xCF,
0x61,0x90,0x55,0xDF,0x84,0x43,0x14,0x8A,0x60,0x2A,0xB2,0xF5,0x7A,0xF4,0x43,0x18,
0xEF,0x30,0x2B,0x06,0x03,0x55,0x1D,0x1F,0x04,0x24,0x30,0x22,0x30,0x20,0xA0,0x1E,
0xA0,0x1C,0x86,0x1A,0x68,0x74,0x74,0x70,0x3A,0x2F,0x2F,0x73,0x73,0x2E,0x73,0x79,
0x6D,0x63,0x62,0x2E,0x63,0x6F,0x6D,0x2F,0x73,0x73,0x2E,0x63,0x72,0x6C,0x30,0x57,
0x06,0x08,0x2B,0x06,0x01,0x05,0x05,0x07,0x01,0x01,0x04,0x4B,0x30,0x49,0x30,0x1F,
0x06,0x08,0x2B,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x86,0x13,0x68,0x74,0x74,0x70,
0x3A,0x2F,0x2F,0x73,0x73,0x2E,0x73,0x79,0x6D,0x63,0x64,0x2E,0x63,0x6F,0x6D,0x30,
0x26,0x06,0x08,0x2B,0x06,0x01,0x05,0x05,0x07,0x30,0x02,0x86,0x1A,0x68,0x74,0x74,
0x70,0x3A,0x2F,0x2F,0x73,0x73,0x2E,0x73,0x79,0x6D,0x63,0x62,0x2E,0x63,0x6F,0x6D,
0x2F,0x73,0x73,0x2E,0x63,0x72,0x74,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,
0x0D,0x01,0x01,0x0B,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0x69,0x9E,0x08,0xE2,0x75,
0x5D,0xA5,0xE2,0x29,0x8C,0xB6,0xA7,0xF0,0x6C,0x30,0x16,0x51,0x24,0x5B,0x76,0x20,
0xCD,0x4F,0xB1,0x26,0xFE,0x01,0x35,0x73,0x7F,0xFF,0x12,0x1B,0x94,0xF5,0x37,0x81,
0x85,0xBF,0x3D,0x44,0xBC,0x06,0x47,0x1C,0x95,0x56,0x52,0xA1,0x17,0xB4,0x22,0xA1,
0x5F,0xB6,0xA1,0xC8,0x38,0xB1,0x16,0x39,0xE1,0x14,0x82,0xF9,0xF6,0x00,0x58,0xF4,
0x62,0x39,0x0E,0xA3,0x08,0x59,0x11,0x62,0xD7,0xEA,0x06,0xC7,0x34,0x92,0xEB,0x1B,
0x01,0xC6,0x80,0x09,0x91,0x03,0xB0,0x51,0x7B,0x2E,0x68,0x7A,0xBA,0xF0,0x51,0x30,
0x68,0x28,0xA0,0xEB,0xD9,0xB2,0x9E,0xD1,0x2A,0x75,0xD5,0x78,0x9B,0x3E,0xC9,0xD7,
0xBE,0x59,0xEB,0xA6,0xF6,0xA4,0x5C,0xCE,0x6A,0x5A,0xCC,0xD1,0x68,0x13,0xE8,0xC2,
0xC2,0xAF,0x85,0x30,0x27,0x44,0xE0,0x5F,0x15,0x0F,0xCC,0xD1,0xC5,0x3C,0x10,0x34,
0x51,0x6F,0x94,0x56,0x39,0x85,0x15,0x48,0xC1,0xCA,0x68,0x49,0x4E,0x89,0xD5,0x39,
0xE8,0x68,0x1F,0xBC,0x0A,0x5F,0x30,0x2C,0xBC,0xED,0x61,0xB3,0x3A,0xF8,0xE8,0xAB,
0x8E,0xC3,0x86,0xD5,0xA3,0xA7,0x41,0xB7,0x15,0xB4,0xC2,0xB5,0xC7,0x91,0x6A,0x7B,
0x84,0xE3,0xA5,0x3B,0x46,0x72,0x01,0xDB,0xBE,0x0E,0xD0,0x1E,0x05,0x36,0x57,0x8D,
0xE4,0x19,0x74,0xB6,0xC5,0xCA,0x10,0xEB,0x7A,0x39,0x8B,0xAE,0x28,0x99,0x67,0x72,
0x9D,0xEF,0x8F,0x78,0x5E,0xA8,0x6A,0x54,0x11,0xC8,0xCE,0xBD,0x84,0x5A,0x85,0x8C,
0xE2,0x6F,0xF9,0x79,0xCA,0x0D,0xA9,0xB4,0x20,0xCC,0xBD,
};

int main() 
{
    Serial pc(USBTX, USBRX);
    pc.baud(115200);
    
    miniTLS.init();
    
    //Deterministic but this is an example!
    for(int i = 0; i < 32; i++)
    {
      uint32_t ticks = us_ticker_read();
      miniTLS.feedPRNG((uint8_t*)&ticks, sizeof(uint32_t));
    }
    
    miniTLS.addCertificate(certificate, sizeof(certificate), pub_key, sizeof(pub_key));
    
    eth.init(); //Use DHCP
 
    int ret = eth.connect();
    if(ret)
    {
      printf("connect() returned %d\r\n", ret);
    }
    
    //GET data
    printf("Trying to fetch page...\r\n");
    ret = http.get("https://mbed.org/media/uploads/donatien/hello.txt", str, 128);
    if (!ret)
    {
      printf("Page fetched successfully - read %d characters\r\n", strlen(str));
      printf("Result: %s\r\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\r\n", ret, http.getHTTPResponseCode());
    }
    
    eth.disconnect();  
 
    while(1) {
    }
}