/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file tls_protocol.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 */

#ifndef TLS_PROTOCOL_H_
#define TLS_PROTOCOL_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"

//See rfc5246 and rfc4492


typedef struct __tls_plaintext
{
    tls_content_type_t type;
    tls_protocol_version_t version;
    uint16_t length; //(MAX 2^14 = 16384)
    //uint8_t* fragment; //(plaintext)
} tls_plaintext_t;

typedef struct __tls_ciphertext
{
  tls_content_type_t type;
  tls_protocol_version_t version;
  uint16_t length; ////(MAX 2^14 + 2048 = 18432)
  /*
  select (SecurityParameters.cipher_type) {
      case stream: GenericStreamCipher;
      case block:  GenericBlockCipher;
      case aead:   GenericAEADCipher;
  } fragment;
  */
  void* cipher;
} tls_ciphertext_t;


typedef struct __tls_block_cipher
{
  uint8_t* initialization_vector;
  uint8_t* fragment;
  uint8_t* mac;
  uint8_t* padding;
  uint8_t padding_length;
} tls_block_cipher_t;

typedef struct __tls_session_keys
{
  uint8_t* server_write_mac_key;
  uint8_t* client_write_mac_key;
  uint8_t* server_write_key;
  uint8_t* client_write_key;
  //uint8_t* server_write_initialization_vector; -- only useful for certain specific ciphers
  //uint8_t* client_write_initialization_vector;
} tls_session_keys_t;

//Known ciphersuites
//CipherSuite TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA    = { 0xC0, 0x04 }
//#define TLS_CIPHERSUITE_ECDH_ECDSA_WITH_AES_128_CBC_SHA { 0xC0, 0x04 }

/* Messages */

typedef struct __tls_message_change_cipher_spec
{
  enum {
    CHANGE_CIPHER_SPEC = 1,
    UNKNOWN = 255
  } type;
} tls_message_change_cipher_spec_t;



typedef uint32_t uint24_t; //!BEWARE!
/*
typedef struct __tls_message_handshake
{
  uint24_t length : 3;
  enum
  {
    hello_request = (0), client_hello = (1), server_hello = (2),
    certificate = (11), server_key_exchange = (12),
    certificate_request = (13), server_hello_done = (14),
    certificate_verify = (15), client_key_exchange = (16),
    finished = (20), unknown = (255)
  } handshake_type;

  select (HandshakeType) {
     case hello_request:       HelloRequest;
     case client_hello:        ClientHello;
     case server_hello:        ServerHello;
     case certificate:         Certificate;
     case server_key_exchange: ServerKeyExchange;
     case certificate_request: CertificateRequest;
     case server_hello_done:   ServerHelloDone;
     case certificate_verify:  CertificateVerify;
     case client_key_exchange: ClientKeyExchange;
     case finished:            Finished;
  } body;

  uint8_t* body;
} tls_message_handshake_t;
*/
#ifdef __cplusplus
}
#endif

#endif /* TLS_PROTOCOL_H_ */
