/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file minitls_errors.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 */

#ifndef MINITLS_ERRORS_H_
#define MINITLS_ERRORS_H_

#ifdef __cplusplus
extern "C" {
#endif

#define MINITLS_OK 0

#define MINITLS_ERR_TIMEOUT                       1
#define MINITLS_ERR_MEMORY                        2
#define MINITLS_ERR_BUFFER_TOO_SMALL              3
#define MINITLS_ERR_DATA_DOES_NOT_FIT_FRAGMENT    4
#define MINITLS_ERR_WRONG_LENGTH                  5
#define MINITLS_ERR_CRYPTO                        6
#define MINITLS_ERR_PARAMETERS                    7

#define MINITLS_ERR_SOCKET_CLOSED                 11
#define MINITLS_ERR_SOCKET_ERROR                  12

#define MINITLS_ERR_PROTOCOL_VERSION              21
#define MINITLS_ERR_PROTOCOL_NON_CONFORMANT       22

#define MINITLS_ERR_NOT_IMPLEMENTED               31
#define MINITLS_ERR_PEER                          32
#define MINITLS_ERR_CONNECTION_CLOSED             33

#define MINITLS_ERR_WRONG_CERTIFICATE             41
#define MINITLS_ERR_WRONG_MAC                     42
#define MINITLS_ERR_PRNG                          43
#define MINITLS_ERR_WRONG_ECDSA                   44
#define MINITLS_ERR_WRONG_CURVE                   45
#define MINITLS_ERR_WRONG_ALIGNMENT_FOR_CIPHER    46
#define MINITLS_ERR_WRONG_RSA_KEY_TYPE            47

typedef int minitls_err_t;

#ifdef __cplusplus
}
#endif

#endif /* MINITLS_ERRORS_H_ */
