/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file TLSSocket.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 */

#ifndef TLSSOCKET_H_
#define TLSSOCKET_H_

#include "core/fwk.h"
#include "MiniTLS.h"

// #include <cstdint> -- new to C++11
#include "inc/minitls_errors.h"

#include "tls/tls_socket.h"

#define TLSSOCKET_BUF_SIZE 5000//804

/** TLS Socket
 * \param pMiniTLS pointer to MiniTLS instance
 */
class TLSSocket
{
public:
  TLSSocket(MiniTLS* pMiniTLS);
  ~TLSSocket();

  minitls_err_t init();

  minitls_err_t connect(const char* hostname, uint16_t port, int timeout);

  minitls_err_t read(uint8_t* buf, size_t minLength, size_t maxLength, size_t* readLength, int timeout);
  minitls_err_t write(uint8_t* buf, size_t length, size_t* writtenLength, int timeout);
  minitls_err_t flush(int timeout);

  minitls_err_t close();

private:
  uint8_t m_writeBuf[TLSSOCKET_BUF_SIZE];
  uint8_t m_readBuf[TLSSOCKET_BUF_SIZE];

  tls_socket_t m_sock;

  MiniTLS* m_pMiniTLS;
};

#endif /* TLSSOCKET_H_ */

