/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file buffer_network.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 */

#ifndef BUFFER_NETWORK_H_
#define BUFFER_NETWORK_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"

//Helpers for buffers in Big Endian format

uint8_t buffer_nu8_read(buffer_t* buffer);
uint16_t buffer_nu16_read(buffer_t* buffer);
uint32_t buffer_nu24_read(buffer_t* buffer);
uint32_t buffer_nu32_read(buffer_t* buffer);
uint64_t buffer_nu64_read(buffer_t* buffer);
void buffer_nbytes_read(buffer_t* buffer, uint8_t* data, size_t size);
void buffer_n_discard(buffer_t* buffer, size_t size);
uint8_t* buffer_current_read_position(buffer_t* buffer);
size_t buffer_get_read_offset(buffer_t* buffer);
void buffer_set_read_offset(buffer_t* buffer, size_t off);

void buffer_nu8_write(buffer_t* buffer, uint8_t hu8);
void buffer_nu16_write(buffer_t* buffer, uint16_t hu16);
void buffer_nu24_write(buffer_t* buffer, uint32_t hu24);
void buffer_nu32_write(buffer_t* buffer, uint32_t hu32);
void buffer_nu64_write(buffer_t* buffer, uint64_t hu64);
void buffer_nbytes_write(buffer_t* buffer, const uint8_t* data, size_t size);
void buffer_n_skip(buffer_t* buffer, size_t size);
uint8_t* buffer_current_write_position(buffer_t* buffer);

#ifdef __cplusplus
}
#endif

#endif /* BUFFER_NETWORK_H_ */
