/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file config.h
 * \copyright Copyright (c) AppNearMe Ltd 2014
 * \author Donatien Garnier
 */

#ifndef CONFIG_H_
#define CONFIG_H_

#ifdef __cplusplus
extern "C" {
#endif

//Enable/disable support for individual protocols
#define MINITLS_CFG_PROTOCOL_TLS_1_2 1
#define MINITLS_CFG_PROTOCOL_TLS_1_1 0
#define MINITLS_CFG_PROTOCOL_TLS_1_0 0
#define MINITLS_CFG_PROTOCOL_SSL_3 0

//Enable/disable key exchange mechanisms (this must match the server's certificate key type)
#define MINITLS_CFG_KEY_RSA_1024 0
#define MINITLS_CFG_KEY_RSA_2048 1
#define MINITLS_CFG_KEY_ECDHE_ECDSA_192 0

//Enable/disable symmetric ciphers
#define MINITLS_CFG_CIPHER_AES_128 0
#define MINITLS_CFG_CIPHER_ARC4 1


#ifdef __cplusplus
}
#endif

#endif /* CONFIG_H_ */
