/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file tls_handshake.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 */

#ifndef TLS_HANDSHAKE_H_
#define TLS_HANDSHAKE_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"
#include "inc/minitls_errors.h"

#include "minitls.h"

#include "tls_socket_defs.h"

minitls_err_t tls_handshake_init(tls_handshake_t* handshake, tls_socket_t* socket);
bool tls_handshake_is_done(tls_handshake_t* handshake);
minitls_err_t tls_handshake_start(tls_handshake_t* handshake);
minitls_err_t tls_handshake_process(tls_handshake_t* handshake, buffer_t* buffer);
void tls_handshake_clean(tls_handshake_t* handshake);

#ifdef __cplusplus
}
#endif

#endif /* TLS_HANDSHAKE_H_ */
