/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file tls_alert.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 */

#ifndef TLS_ALERT_H_
#define TLS_ALERT_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"
#include "inc/minitls_errors.h"
#include "tls_record.h"

typedef enum __tls_message_alert_level
{
  TLS_ALERT_WARNING = 1, TLS_ALERT_FATAL = 2
} tls_message_alert_level_t;

typedef enum __tls_message_alert_description
{
      CLOSE_NOTIFY = (0),
      UNEXPECTED_MESSAGE = (10),
      BAD_RECORD_MAC = (20),
      DECRYPTION_FAILED_RESERVED = (21),
      RECORD_OVERFLOW = (22),
      DECOMPRESSION_FAILURE = (30),
      HANDSHAKE_FAILURE = (40),
      NO_CERTIFICATE_RESERVED = (41),
      BAD_CERTIFICATE = (42),
      UNSUPPORTED_CERTIFICATE = (43),
      CERTIFICATE_REVOKED = (44),
      CERTIFICATE_EXPIRED = (45),
      CERTIFICATE_UNKNOWN = (46),
      ILLEGAL_PARAMETER = (47),
      UNKNOWN_CA = (48),
      ACCESS_DENIED = (49),
      DECODE_ERROR =(50),
      DECRYPT_ERROR = (51),
      EXPORT_RESTRICTION_RESERVED = (60),
      PROTOCOL_VERSION = (70),
      INSUFFICIENT_SECURITY = (71),
      INTERNAL_ERROR = (80),
      USER_CANCELED = (90),
      NO_RENEGOCIATION = (100),
      UNSUPPORTED_EXTENSION = (110),
 } tls_message_alert_description_t;
/*
typedef struct __tls_message_alert
{
  tls_message_alert_level_t level;
  tls_message_alert_description_t description;
} PACKED tls_message_alert_t;
*/
minitls_err_t tls_alert_send( tls_record_t* record, tls_message_alert_level_t level, tls_message_alert_description_t description, buffer_t* buffer_tx );
minitls_err_t tls_alert_process( tls_record_t* record, buffer_t* buffer_rx );


#ifdef __cplusplus
}
#endif

#endif /* TLS_ALERT_H_ */
