/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file ltc.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 */

#ifndef LTC_H_
#define LTC_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"
#include "crypto/crypto_ecc.h"
#include "crypto/crypto_math.h"


/*
 Config
 * */
/* ECC */
#define LTC_MECC
#define MPI

#define ECC_BUF_SIZE 256 //FIXME should it be *that* big?

/* use Shamir's trick for point mul (speeds up signature verification) */
//#define LTC_ECC_SHAMIR -- nope, consumes too much memory

#define LTC_ECC_TIMING_RESISTANT

#define zeromem(buf,size) memset((buf), 0, (size))

typedef crypto_ecc_point_t ecc_point;

/* low level functions */
int ltc_init_multi(void *a, ...);
void ltc_deinit_multi(void *a, ...);
#if 0
ecc_point *ltc_ecc_new_point(void);
void       ltc_ecc_del_point(ecc_point *p);
#endif
int        ltc_ecc_is_valid_idx(int n);

/* point ops (mp == montgomery digit) */
/* R = 2P */
int ltc_ecc_projective_dbl_point(ecc_point *P, ecc_point *R, void *modulus, void *mp);

/* R = P + Q */
int ltc_ecc_projective_add_point(ecc_point *P, ecc_point *Q, ecc_point *R, void *modulus, void *mp);


/* R = kG */
int ltc_ecc_mulmod(void *k, ecc_point *G, ecc_point *R, void *modulus, int map);

#ifdef LTC_ECC_SHAMIR
/* kA*A + kB*B = C */
int ltc_ecc_mul2add(ecc_point *A, void *kA,
                    ecc_point *B, void *kB,
                    ecc_point *C,
                         void *modulus);
#endif


/* map P to affine from projective */
int ltc_ecc_map(ecc_point *P, void *modulus, void *mp);

#define LTC_ARGCHK(x)


#ifdef __cplusplus
}
#endif

#endif /* LTC_H_ */
