/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file crypto_md5.h
 * \copyright Copyright (c) AppNearMe Ltd 2014
 * \author Donatien Garnier
 */

#ifndef CRYPTO_MD5_H_
#define CRYPTO_MD5_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"

#define MD5_SIZE 16 //128 bits
#define MD5_BLOCK_SIZE 64

typedef struct __crypto_md5
{
  uint64_t length;
  uint32_t state[4], curlen;
  uint8_t buf[64];
} crypto_md5_t;

void crypto_md5_init(crypto_md5_t* hash);
void crypto_md5_update(crypto_md5_t* hash, const uint8_t* data, size_t size);
void crypto_md5_end(crypto_md5_t* hash, uint8_t* out);

void crypto_md5_copy(crypto_md5_t* hashTo, crypto_md5_t* hashFrom);

#ifdef __cplusplus
}
#endif

#endif /* CRYPTO_MD5_H_ */
