/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file crypto_math.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 */

#ifndef CRYPTO_MATH_H_
#define CRYPTO_MATH_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "math/headers/tfm.h"

#define MP_LT   -1
#define MP_EQ    0
#define MP_GT    1

/* replies */
#define MP_YES        1   /* yes response */
#define MP_NO         0   /* no response */

#define MP_DIGIT_BIT                 DIGIT_BIT

/* some handy macros */
#define mp_init(a)                   fp_init(a)
#define mp_init_multi                ltc_init_multi
extern int max_used;
#define mp_clear(a)                  /*do{ max_used = MAX(max_used, ((fp_int*)a)->used); printf("max used=%ul\r\n", max_used);*/ memset((a), 0, sizeof(fp_int)); /*}while(0) //fp_deinit(a)*/
#define mp_clear_multi               ltc_deinit_multi
#define mp_init_copy(a, b)           fp_init_copy(a, b)

#define mp_neg(a, b)                 fp_neg(a, b)
#define mp_copy(a, b)                fp_copy(a, b)

#define mp_set(a, b)                 fp_set(a, b)
#define mp_set_int(a, b)             fp_set_int(a, b)
#define mp_get_int(a)                fp_get_int(a)
#define mp_get_digit(a, n)           (((n) >= ((fp_int*)a)->used || (n) < 0) ? 0 : ((fp_int*)a)->dp[(n)])
#define mp_get_digit_count(a)        (((fp_int*)a)->used)
#define mp_cmp(a, b)                 fp_cmp(a, b)
#define mp_cmp_d(a, b)               fp_cmp_d(a, b)
#define mp_count_bits(a)             fp_count_bits(a)
#define mp_cnt_lsb(a)                fp_count_lsb_bits(a)
#define mp_2expt(a, b)               fp_twoexpt(a, b)

#define mp_read_radix(a, b, c)       fp_read_radix(a, b, c)
#define mp_toradix(a, b, c)          fp_write_radix(a, b, c)
#define mp_unsigned_bin_size(a)      fp_unsigned_bin_size(a)
#define mp_to_unsigned_bin(a, b)     fp_to_unsigned_bin(a, b)
#define mp_read_unsigned_bin(a, b, c) fp_read_unsigned_bin(a, b, c)

#define mp_add(a, b, c)              fp_add(a, b, c)
#define mp_add_d(a, b, c)            fp_addi(a, b, c)
#define mp_sub(a, b, c)              fp_sub(a, b, c)
#define mp_sub_d(a, b, c)            fp_subi(a, b, c)
#define mp_mul(a, b, c)              fp_mul(a, b, c)
#define mp_mul_d(a, b, c)            fp_muli(a, b, c)
#define mp_sqr(a, b)                 fp_sqr(a, b)
#define mp_div(a, b, c, d)           fp_mpdiv(a, b, c, d)
#define mp_div_2(a, b)               fp_div_2(a, b)
#define mp_mod(a, b, c)              fp_div(a, b, NULL, c)
#define mp_mod_d(a, b, c)            fp_modi(a, b, c)
#define mp_gcd(a, b, c)              fp_gcd(a, b, c)
#define mp_lcm(a, b, c)              fp_lcm(a, b, c)

#define mp_mulmod(a, b, c, d)        fp_mulmod(a, b, c, d)
#define mp_sqrmod(a, b, c)           fp_sqrmod(a, b, c)
#define mp_invmod(a, b, c)           fp_invmod(a, b, c)

#define mp_montgomery_setup(a, b)    fp_montgomery_setup(a, b)
#define mp_montgomery_normalization(a, b) fp_montgomery_calc_normalization(a, b)
#define mp_montgomery_reduce(a, b, c)   fp_montgomery_reduce(a, b, *((fp_digit*)c))
#define mp_montgomery_free(a)        memset((a), 0, sizeof(fp_digit)) // fp_montgomery_deinit(a)

#define mp_exptmod(a,b,c,d)          fp_exptmod(a,b,c,d)
#define mp_prime_is_prime(a, b, c)   fp_isprime(a, c)

#define mp_iszero(a)                 (mp_cmp_d(a, 0) == MP_EQ ? MP_YES : MP_NO)
#define mp_isodd(a)                  (mp_get_digit_count(a) > 0 ? (mp_get_digit(a, 0) & 1 ? MP_YES : MP_NO) : MP_NO)
#define mp_exch(a, b)                do { void *ABC__tmp = a; a = b; b = ABC__tmp; } while(0);

#define mp_tohex(a, b)               mp_toradix(a, b, 16)

#ifdef __cplusplus
}
#endif

#endif /* CRYPTO_MATH_H_ */
