/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file crypto_aes_128_cbc.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 */

#ifndef CRYPTO_AES_128_CBC_H_
#define CRYPTO_AES_128_CBC_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"
#include "inc/minitls_errors.h"
#include "crypto_aes_128.h"

minitls_err_t crypto_aes_128_cbc_encrypt(crypto_aes_128_t* cipher, buffer_t* initialization_vector, buffer_t* buffer);
minitls_err_t crypto_aes_128_cbc_decrypt(crypto_aes_128_t* cipher, buffer_t* initialization_vector, buffer_t* buffer);

#ifdef __cplusplus
}
#endif

#endif /* CRYPTO_AES_128_CBC_H_ */
