/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file crypto_aes_128.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 */

#ifndef CRYPTO_AES_128_H_
#define CRYPTO_AES_128_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "inc/minitls_errors.h"

#define AES_128_KEY_SIZE 16 //128 bits
#define AES_128_BLOCK_SIZE AES_128_KEY_SIZE

//This cipher is based on the Rijndael cipher and the rijndael.c reference implementation

#define AES_128_EXPANDED_KEY_SIZE (28 + AES_128_KEY_SIZE)

typedef enum __crypto_aes_128_key_expansion_type
{
  expand_encryption_key,
  expand_decryption_key,
} crypto_aes_128_key_expansion_type_t;

//One-way implementation only
typedef struct __crypto_aes_128
{
  uint32_t expanded_key[AES_128_EXPANDED_KEY_SIZE];
} crypto_aes_128_t;

//Asymmetric impl: To diminish key sizes, only the AES encipher OR decipher operation can be executed - on the other side, only the reverse operation is executed
void crypto_aes_128_init(crypto_aes_128_t* aes_128, const uint8_t* key, crypto_aes_128_key_expansion_type_t expansion_type);

void crypto_aes_128_encrypt(crypto_aes_128_t* aes_128, const uint8_t* plaintext, uint8_t* ciphertext);
void crypto_aes_128_decrypt(crypto_aes_128_t* aes_128, const uint8_t* ciphertext, uint8_t* plaintext);

#ifdef __cplusplus
}
#endif

#endif /* CRYPTO_AES_128_H_ */
